/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.shortcuts;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.shortcuts.ProjectPermissionsHelper;
import com.atlassian.jira.projects.shortcuts.ProjectShortcut;
import com.atlassian.jira.projects.shortcuts.ShortcutsManager;
import com.atlassian.jira.projects.shortcuts.ShortcutsService;
import com.atlassian.jira.projects.shortcuts.events.ShortcutEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class DefaultShortcutsService
implements ShortcutsService {
    public static final int MAX_NAME_LENGTH = 255;
    private final ShortcutsManager shortcutsManager;
    private final ProjectPermissionsHelper projectPermissionsHelper;
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final EventPublisher eventPublisher;
    private final DarkFeatureManager darkFeatureManager;
    private static final String[] whitelistedPrefixed = new String[]{"http://", "https://", "ftp://", "ftps://", "mailto:", "skype:", "callto:", "facetime:", "git:", "irc:", "irc6:", "news:", "nntp:", "feed:", "cvs:", "svn:", "mvn:", "ssh:", "itms:", "notes:", "smb:", "hipchat:", "sourcetree:"};

    @Autowired
    public DefaultShortcutsService(ShortcutsManager shortcutsManager, ProjectPermissionsHelper projectPermissionsHelper, @ComponentImport I18nHelper.BeanFactory i18nHelperFactory, @ComponentImport EventPublisher eventPublisher, @ComponentImport DarkFeatureManager darkFeatureManager) {
        this.shortcutsManager = shortcutsManager;
        this.projectPermissionsHelper = projectPermissionsHelper;
        this.i18nHelperFactory = i18nHelperFactory;
        this.eventPublisher = eventPublisher;
        this.darkFeatureManager = darkFeatureManager;
    }

    public Either<ErrorCollection, ProjectShortcut> addShortcut(ProjectShortcut shortcut, ApplicationUser user) {
        Preconditions.checkArgument((shortcut.getId() == null ? 1 : 0) != 0, (Object)"Cannot add shortcut with already defined ID");
        Option<ErrorCollection> errorCollections = this.checkPermissions(this.projectPermissionsHelper.canModifyShortcuts(shortcut.getProject(), user), user);
        if (errorCollections.isDefined()) {
            return Either.left((Object)errorCollections.get());
        }
        Either<ErrorCollection, ProjectShortcut> validation = this.validateShortcut(shortcut, user, (Option<String>)Option.none());
        if (validation.isLeft()) {
            return validation;
        }
        Either<ErrorCollection, ProjectShortcut> managerResult = this.shortcutsManager.addShortcut(shortcut);
        if (managerResult.isRight()) {
            this.eventPublisher.publish((Object)ShortcutEvent.Builder.from((ProjectShortcut)managerResult.right().get(), this.areIconsEnabledForUser(user)).created());
        }
        return managerResult;
    }

    public Either<ErrorCollection, ProjectShortcut> updateShortcut(ProjectShortcut shortcut, ApplicationUser user) {
        Option<ProjectShortcut> existingShortcut = this.shortcutsManager.getShortcut(shortcut.getId());
        if (!existingShortcut.isDefined()) {
            return this.notFound(user);
        }
        if (!((ProjectShortcut)existingShortcut.get()).getProject().equals(shortcut.getProject())) {
            return this.notFound(user);
        }
        Integer oldShortcutNameLength = ((ProjectShortcut)existingShortcut.get()).getName().length();
        Integer oldShortcutUrlLength = ((ProjectShortcut)existingShortcut.get()).getUrl().length();
        String oldIconName = ((ProjectShortcut)existingShortcut.get()).getIcon();
        Option<ErrorCollection> writePermissions = this.checkPermissions(this.projectPermissionsHelper.canModifyShortcuts(shortcut.getProject(), user), user);
        if (writePermissions.isDefined()) {
            Option<ErrorCollection> readPermissions = this.checkPermissions(this.projectPermissionsHelper.canViewShortcuts(shortcut.getProject(), user), user);
            if (readPermissions.isDefined()) {
                return this.notFound(user);
            }
            return Either.left((Object)writePermissions.get());
        }
        Either<ErrorCollection, ProjectShortcut> validation = this.validateShortcut(shortcut, user, (Option<String>)Option.option((Object)oldIconName));
        if (validation.isLeft()) {
            return validation;
        }
        Either<ErrorCollection, ProjectShortcut> managerResult = this.shortcutsManager.updateShortcut(shortcut);
        if (managerResult.isRight()) {
            this.eventPublisher.publish((Object)ShortcutEvent.Builder.from((ProjectShortcut)managerResult.right().get(), this.areIconsEnabledForUser(user)).edited(oldShortcutNameLength, oldShortcutUrlLength, oldIconName));
        }
        return managerResult;
    }

    private Either<ErrorCollection, ProjectShortcut> validateShortcut(ProjectShortcut shortcut, ApplicationUser user, Option<String> oldIconName) {
        I18nHelper i18n = this.i18nHelperFactory.getInstance(user);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (StringUtils.isBlank((CharSequence)shortcut.getName())) {
            errorCollection.addError("name", i18n.getText("project.shortcuts.name.cannot.be.empty"), ErrorCollection.Reason.VALIDATION_FAILED);
        } else if (shortcut.getName().length() > 255) {
            errorCollection.addError("name", i18n.getText("project.shortcuts.name.too.long", (Object)255), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (StringUtils.isBlank((CharSequence)shortcut.getUrl())) {
            errorCollection.addError("url", i18n.getText("project.shortcuts.url.cannot.be.empty"), ErrorCollection.Reason.VALIDATION_FAILED);
        } else if (!this.isUrlSafe(shortcut.getUrl())) {
            errorCollection.addError("url", i18n.getText("project.shortcuts.url.is.not.safe", shortcut.getUrl()), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (this.assertIconNotModifiedIfShortcutIconsDisabled(shortcut, user, oldIconName)) {
            errorCollection.addError("icon", i18n.getText("project.shortcuts.cannot.change.icon.when.darkfeature.is.disabled", shortcut.getUrl()), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        this.eventPublisher.publish((Object)ShortcutEvent.Builder.from(shortcut, this.areIconsEnabledForUser(user)).validated(!errorCollection.hasAnyErrors()));
        if (errorCollection.hasAnyErrors()) {
            return Either.left((Object)errorCollection);
        }
        return Either.right((Object)shortcut);
    }

    private Option<ErrorCollection> checkPermissions(Option<String> permissionsResult, ApplicationUser user) {
        if (permissionsResult.isEmpty()) {
            return Option.none();
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18n = this.i18nHelperFactory.getInstance(user);
        errorCollection.addErrorMessage(i18n.getText((String)permissionsResult.get()), ErrorCollection.Reason.FORBIDDEN);
        return Option.some((Object)errorCollection);
    }

    private boolean areIconsEnabledForUser(ApplicationUser user) {
        return user != null && user.getKey() != null && this.darkFeatureManager.isFeatureEnabledForUser(new UserKey(user.getKey()), "com.atlassian.jira.projects.ProjectCentricNavigation.ProjectShortcutIcons");
    }

    private boolean assertIconNotModifiedIfShortcutIconsDisabled(ProjectShortcut shortcut, ApplicationUser user, Option<String> oldIconName) {
        return !this.areIconsEnabledForUser(user) && !StringUtils.equals((CharSequence)((CharSequence)oldIconName.getOrElse((Object)"")), (CharSequence)shortcut.getIcon());
    }

    public boolean isUrlSafe(String url) {
        String trimmedLoweredURL = StringUtils.lowerCase((String)StringUtils.trim((String)url));
        return StringUtils.startsWithAny((CharSequence)trimmedLoweredURL, (CharSequence[])whitelistedPrefixed);
    }

    public List<ProjectShortcut> getShortcuts(Project project, ApplicationUser user) {
        Option<ErrorCollection> errorCollections = this.checkPermissions(this.projectPermissionsHelper.canViewShortcuts(project, user), user);
        if (errorCollections.isDefined()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.shortcutsManager.getShortcuts(project));
    }

    public Either<ErrorCollection, ProjectShortcut> getShortcut(Integer id, ApplicationUser user) {
        Option<ProjectShortcut> shortcut = this.shortcutsManager.getShortcut(id);
        if (shortcut.isDefined()) {
            Option<ErrorCollection> errorCollections = this.checkPermissions(this.projectPermissionsHelper.canViewShortcuts(((ProjectShortcut)shortcut.get()).getProject(), user), user);
            if (errorCollections.isDefined()) {
                return Either.left((Object)errorCollections.get());
            }
            return Either.right((Object)shortcut.get());
        }
        return this.notFound(user);
    }

    public Either<ErrorCollection, ProjectShortcut> deleteShortcut(Integer id, ApplicationUser user) {
        Option<ProjectShortcut> shortcut = this.shortcutsManager.getShortcut(id);
        if (!shortcut.isDefined()) {
            return this.notFound(user);
        }
        Option<ErrorCollection> errorCollections = this.checkPermissions(this.projectPermissionsHelper.canModifyShortcuts(((ProjectShortcut)shortcut.get()).getProject(), user), user);
        if (errorCollections.isDefined()) {
            return Either.left((Object)errorCollections.get());
        }
        Either<ErrorCollection, ProjectShortcut> managerResult = this.shortcutsManager.deleteShortcut(id);
        if (managerResult.isRight()) {
            this.eventPublisher.publish((Object)ShortcutEvent.Builder.from((ProjectShortcut)shortcut.get(), this.areIconsEnabledForUser(user)).deleted());
        }
        return managerResult;
    }

    private Either<ErrorCollection, ProjectShortcut> notFound(ApplicationUser user) {
        I18nHelper i18n = this.i18nHelperFactory.getInstance(user);
        SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        simpleErrorCollection.addErrorMessage(i18n.getText("project.shortcuts.cannot.find.shortcut"), ErrorCollection.Reason.NOT_FOUND);
        return Either.left((Object)simpleErrorCollection);
    }
}

