/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.servlet;

import com.atlassian.fugue.Option;
import com.atlassian.jira.projects.servlet.ProjectNotFoundPageRenderer;
import com.atlassian.jira.projects.web.redirect.LoginRedirectProvider;
import com.atlassian.jira.util.ErrorCollection;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectPageErrorHandler {
    private final ProjectNotFoundPageRenderer projectNotFoundPageRenderer;
    private final LoginRedirectProvider loginRedirectProvider;

    @Autowired
    public ProjectPageErrorHandler(ProjectNotFoundPageRenderer projectNotFoundPageRenderer, LoginRedirectProvider loginRedirectProvider) {
        this.projectNotFoundPageRenderer = projectNotFoundPageRenderer;
        this.loginRedirectProvider = loginRedirectProvider;
    }

    public void writeErrorResponse(ErrorCollection errorCollection, Option<String> projectKey, HttpServletRequest request, HttpServletResponse response) {
        Set reasons = errorCollection.getReasons();
        try {
            if (reasons.contains(ErrorCollection.Reason.NOT_LOGGED_IN)) {
                response.sendRedirect(this.loginRedirectProvider.getLoginRedirectUrl(request));
            } else if (reasons.contains(ErrorCollection.Reason.NOT_FOUND) || reasons.contains(ErrorCollection.Reason.FORBIDDEN)) {
                response.setStatus(ErrorCollection.Reason.NOT_FOUND.getHttpStatusCode());
                if (projectKey.isDefined()) {
                    response.getWriter().append(this.projectNotFoundPageRenderer.renderPageNotFound((String)projectKey.get()));
                } else {
                    response.getWriter().append(this.projectNotFoundPageRenderer.renderProjectNotFound());
                }
            } else if (!reasons.isEmpty()) {
                response.sendError(ErrorCollection.Reason.getWorstReason((Collection)reasons).getHttpStatusCode());
            } else {
                response.sendError(ErrorCollection.Reason.SERVER_ERROR.getHttpStatusCode());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

