/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.web.priority;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.URLEncoder;
import com.atlassian.jira.projects.page.AbstractProjectsPageContextProvider;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.DataRequest;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.JqlFactory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.priority.PriorityCount;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.priority.PriorityCountService;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.web.priority.PriorityCountView;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PrioritySummaryContextProvider
extends AbstractProjectsPageContextProvider {
    private static final int MAX_DISPLAYABLE_PRIORITIES = 5;
    private static final String NO_PRIORITIES_KEY = "gadget.filterstats.priority.nopriority";
    private final I18nHelper.BeanFactory beanFactory;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    private final SearchService searchService;
    private final PriorityCountService priorityCountService;
    private final JqlFactory jqlFactory;

    public PrioritySummaryContextProvider(@ComponentImport I18nHelper.BeanFactory beanFactory, @ComponentImport JaxbJsonMarshaller jaxbJsonMarshaller, @ComponentImport SearchService searchService, PriorityCountService priorityCountService, JqlFactory jqlFactory) {
        this.beanFactory = beanFactory;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
        this.searchService = searchService;
        this.priorityCountService = priorityCountService;
        this.jqlFactory = jqlFactory;
    }

    @Override
    protected Map<String, Object> getContextMap(Project project, Map<String, Object> originalContext) {
        ImmutableMap.Builder context = ImmutableMap.builder();
        ApplicationUser currentUser = (ApplicationUser)originalContext.get("user");
        DataRequest dataRequest = new DataRequest(project, currentUser);
        List priorityCountViews = (List)this.priorityCountService.getPriorityCounts(dataRequest).stream().map(priorityCount -> this.toPriorityCountView((PriorityCount)priorityCount, currentUser, project)).collect(CollectorsUtil.toImmutableList());
        context.put((Object)"displayablePriorityCounts", this.getDisplayablePriorities(priorityCountViews));
        this.populateRemainingPrioritiesForContext((ImmutableMap.Builder<String, Object>)context, priorityCountViews);
        return context.build();
    }

    private PriorityCountView toPriorityCountView(PriorityCount priorityCount, ApplicationUser user, Project project) {
        Optional<Priority> priorityOptional = priorityCount.getPriority();
        return new PriorityCountView(this.translatedPriorityNameForUser(priorityOptional, user), priorityOptional.map(IssueConstant::getCompleteIconUrl).orElse(""), priorityOptional.map(IssueConstant::getSequence).orElse(Long.MAX_VALUE), priorityCount.getCount(), this.jqlForPriorityInProject(priorityOptional, project));
    }

    private String jqlForPriorityInProject(Optional<Priority> priorityOptional, Project project) {
        Query priorityQuery = priorityOptional.map(priority -> this.jqlFactory.getQueryForAllIssuesWithPriority(project, (Priority)priority)).orElse(this.jqlFactory.getQueryForAllIssuesWithNoPriority(project));
        return URLEncoder.encodeQueryStringValue(this.searchService.getJqlString(priorityQuery));
    }

    private void populateRemainingPrioritiesForContext(ImmutableMap.Builder<String, Object> context, List<PriorityCountView> allPriorities) {
        List<PriorityCountView> remainingPriorities = this.getRemainingPriorities(allPriorities);
        context.put((Object)"remainingPriorityCountsJson", (Object)this.jaxbJsonMarshaller.marshal(remainingPriorities));
        context.put((Object)"numRemainingPriorityCounts", (Object)remainingPriorities.size());
    }

    private List<PriorityCountView> getDisplayablePriorities(List<PriorityCountView> allPriorities) {
        return (List)allPriorities.stream().limit(5L).collect(CollectorsUtil.toImmutableList());
    }

    private List<PriorityCountView> getRemainingPriorities(List<PriorityCountView> allPriorities) {
        return (List)allPriorities.stream().skip(5L).collect(CollectorsUtil.toImmutableList());
    }

    private String translatedPriorityNameForUser(Optional<Priority> priorityOptional, ApplicationUser user) {
        return priorityOptional.map(priority -> priority.getNameTranslation(this.beanFactory.getInstance(user))).orElse(this.beanFactory.getInstance(user).getText(NO_PRIORITIES_KEY));
    }
}

