/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.web;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.util.Map;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class IssueSummaryVignetteDisplayCondition
implements Condition {
    static final String DARK_FEATURE_STRING_IDENTIFIER = "com.atlassian.jira.projects.issue.summary.vignettes";
    private final DarkFeatureManager darkFeatureManager;
    private final IssueManager issueManager;

    @Autowired
    public IssueSummaryVignetteDisplayCondition(@ComponentImport DarkFeatureManager darkFeatureManager, @ComponentImport IssueManager issueManager) {
        this.darkFeatureManager = darkFeatureManager;
        this.issueManager = issueManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Project project = (Project)context.get("project");
        return this.isDarkFeatureEnabled() && this.doesTheProjectHaveIssues(project);
    }

    private boolean doesTheProjectHaveIssues(Project project) {
        return this.issueManager.getIssueCountForProject(project.getId()) > 0L;
    }

    private boolean isDarkFeatureEnabled() {
        return this.darkFeatureManager.isFeatureEnabledForCurrentUser(DARK_FEATURE_STRING_IDENTIFIER);
    }
}

