/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.priority;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.PriorityStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.IssueMapperFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Comparator;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class PriorityMapperFactory
implements IssueMapperFactory<Priority> {
    private final ConstantsManager constantsManager;

    @Autowired
    public PriorityMapperFactory(@ComponentImport ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    @Override
    public StatisticsMapper<Priority> getMapper() {
        return new PriorityStatisticsMapperAdapter(new PriorityStatisticsMapper(this.constantsManager));
    }

    private class PriorityStatisticsMapperAdapter
    implements StatisticsMapper<Priority> {
        private final PriorityStatisticsMapper delegate;

        public PriorityStatisticsMapperAdapter(PriorityStatisticsMapper priorityStatisticsMapper) {
            this.delegate = priorityStatisticsMapper;
        }

        public boolean isValidValue(Priority value) {
            return this.delegate.isValidValue((IssueConstant)value);
        }

        public boolean isFieldAlwaysPartOfAnIssue() {
            return this.delegate.isFieldAlwaysPartOfAnIssue();
        }

        public SearchRequest getSearchUrlSuffix(Priority value, SearchRequest searchRequest) {
            return this.delegate.getSearchUrlSuffix((IssueConstant)value, searchRequest);
        }

        public String getDocumentConstant() {
            return this.delegate.getDocumentConstant();
        }

        public Priority getValueFromLuceneField(String documentValue) {
            return (Priority)this.delegate.getValueFromLuceneField(documentValue);
        }

        public Comparator<Priority> getComparator() {
            return (priority1, priority2) -> this.delegate.getComparator().compare(priority1, priority2);
        }
    }
}

