/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.priority;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.DataRequest;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.IssueCountAccessor;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.IssueMapperFactory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.StatisticAccessorBeanFactory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.priority.PriorityCount;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class PriorityCountService {
    private final IssueCountAccessor issueCountAccessor;
    private final IssueMapperFactory<Priority> mapperFactory;
    private final StatisticAccessorBeanFactory beanFactory;

    @Autowired
    public PriorityCountService(IssueCountAccessor issueCountAccessor, IssueMapperFactory<Priority> mapperFactory, StatisticAccessorBeanFactory beanFactory) {
        this.issueCountAccessor = (IssueCountAccessor)Preconditions.checkNotNull((Object)issueCountAccessor);
        this.mapperFactory = (IssueMapperFactory)Preconditions.checkNotNull(mapperFactory);
        this.beanFactory = (StatisticAccessorBeanFactory)Preconditions.checkNotNull((Object)beanFactory);
    }

    public List<PriorityCount> getPriorityCounts(DataRequest dataRequest) {
        Map<Priority, Long> prioritiesAndCounts = this.issueCountAccessor.getNonZeroIssueCount(this.beanFactory.createAccessorBeanForAllIssues(dataRequest), this.mapperFactory.getMapper());
        return (List)prioritiesAndCounts.entrySet().stream().map(this::toPriorityCount).sorted().collect(CollectorsUtil.toImmutableList());
    }

    private PriorityCount toPriorityCount(Map.Entry<Priority, Long> entry) {
        Priority priority = entry.getKey();
        Long count = entry.getValue();
        return new PriorityCount(priority, count);
    }
}

