/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.priority;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.priority.Priority;
import java.util.Objects;
import java.util.Optional;

public class PriorityCount
implements Comparable<PriorityCount> {
    private final Optional<Priority> priority;
    private final Long count;

    public PriorityCount(Priority priority, Long count) {
        this.priority = Optional.ofNullable(priority);
        this.count = count;
    }

    public Optional<Priority> getPriority() {
        return this.priority;
    }

    public Long getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriorityCount that = (PriorityCount)o;
        return Objects.equals(this.priority, that.priority) && Objects.equals(this.count, that.count);
    }

    public int hashCode() {
        return Objects.hash(this.priority, this.count);
    }

    @Override
    public int compareTo(PriorityCount other) {
        return this.getSequenceElseMaxValue(this.priority).compareTo(this.getSequenceElseMaxValue(other.getPriority()));
    }

    private Long getSequenceElseMaxValue(Optional<Priority> priorityOptional) {
        return priorityOptional.map(IssueConstant::getSequence).orElse(Long.MAX_VALUE);
    }
}

