/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service;

import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import javax.inject.Named;

@Named
public class JqlFactory {
    public Query getQueryForAllIssues(Project project) {
        return JqlQueryBuilder.newBuilder((Query)this.buildGenericQuery()).where().project(new Long[]{project.getId()}).endWhere().buildQuery();
    }

    public Query getQueryForAllIssuesWithPriority(Project project, Priority priority) {
        return JqlQueryBuilder.newBuilder((Query)this.getQueryForAllIssues(project)).where().defaultAnd().priority(new String[]{priority.getName()}).endWhere().buildQuery();
    }

    public Query getQueryForAllIssuesWithNoPriority(Project project) {
        return JqlQueryBuilder.newBuilder((Query)this.getQueryForAllIssues(project)).where().defaultAnd().priority().isEmpty().endWhere().buildQuery();
    }

    public Query getQueryForAllUnresolvedIssues(Project project) {
        return JqlQueryBuilder.newBuilder((Query)this.getQueryForAllIssues(project)).where().defaultAnd().unresolved().endWhere().buildQuery();
    }

    public Query getQueryForAllUnresolvedIssuesWithAssignee(Project project, ApplicationUser assignee) {
        return JqlQueryBuilder.newBuilder((Query)this.getQueryForAllUnresolvedIssues(project)).where().defaultAnd().assigneeUser(assignee.getUsername()).endWhere().buildQuery();
    }

    public Query getQueryForAllUnassignedAndUnresolvedIssues(Project project) {
        return JqlQueryBuilder.newBuilder((Query)this.getQueryForAllUnresolvedIssues(project)).where().defaultAnd().assigneeIsEmpty().endWhere().buildQuery();
    }

    private Query buildGenericQuery() {
        return JqlQueryBuilder.newBuilder().orderBy().priority(SortOrder.DESC).issueKey(SortOrder.ASC).endOrderBy().buildQuery();
    }
}

