/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service;

import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import javax.inject.Named;

@Named
public class IssueCountAccessor {
    public <T> Map<T, Long> getNonZeroIssueCount(StatisticAccessorBean accessorBean, StatisticsMapper<T> statisticsMapper) {
        try {
            StatisticMapWrapper data = accessorBean.getWrapper(statisticsMapper, StatisticAccessorBean.OrderBy.NATURAL, StatisticAccessorBean.Direction.ASC);
            return Maps.transformValues((Map)data.getStatistics(), Integer::longValue);
        }
        catch (SearchException e) {
            return Collections.emptyMap();
        }
    }
}

