/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary;

import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.ActivityStreamFragment;
import com.atlassian.jira.projects.page.AbstractProjectsPageContextProvider;
import com.atlassian.jira.projects.page.summary.SummaryPageContextProvider;
import com.atlassian.jira.projects.util.WebPanelRenderer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Scanned
public class ProjectActivitySummaryContextProvider
extends AbstractProjectsPageContextProvider {
    protected static final Logger log = Logger.getLogger(SummaryPageContextProvider.class);
    public static final String VIGNETTE_WEB_PANEL_LOCATION = "com.atlassian.jira.jira-projects-plugin:summary-page-vignette";
    private final ProjectDescriptionRenderer projectDescriptionRenderer;
    private final WebPanelRenderer webPanelRenderer;
    private final SearchProvider searchProvider;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final ActivityStreamFragment activityStreamFragment;

    public ProjectActivitySummaryContextProvider(WebPanelRenderer webPanelRenderer, ActivityStreamFragment activityStreamFragment, @ComponentImport ProjectDescriptionRenderer projectDescriptionRenderer, @ComponentImport SearchProvider searchProvider, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport PermissionManager permissionManager) {
        this.projectDescriptionRenderer = projectDescriptionRenderer;
        this.webPanelRenderer = webPanelRenderer;
        this.searchProvider = searchProvider;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.activityStreamFragment = activityStreamFragment;
    }

    @Override
    protected Map<String, Object> getContextMap(Project project, Map<String, Object> originalContext) {
        ImmutableMap.Builder context = ImmutableMap.builder();
        context.put((Object)"project", (Object)project);
        context.put((Object)"vignette", this.webPanelRenderer.renderWebPanels(VIGNETTE_WEB_PANEL_LOCATION, originalContext).getOrElse((Object)""));
        if (StringUtils.isNotBlank((CharSequence)project.getDescription())) {
            context.put((Object)"description", (Object)this.projectDescriptionRenderer.getViewHtml(project));
        }
        context.put((Object)"activityStream", (Object)this.activityStreamFragment.getPanelHtml(project.getKey()));
        this.populateContextForProjectWelcome(project, (ImmutableMap.Builder<String, Object>)context);
        return context.build();
    }

    private void populateContextForProjectWelcome(Project project, ImmutableMap.Builder<String, Object> context) {
        if (project != null) {
            boolean showProjectWelcome = this.getIssueCountForProject(project) == 0L;
            context.put((Object)"showProjectWelcome", (Object)showProjectWelcome);
            if (showProjectWelcome) {
                ApplicationUser user = this.jiraAuthenticationContext.getUser();
                context.put((Object)"canCreateIssue", (Object)this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, user));
            }
        }
    }

    private long getIssueCountForProject(@Nonnull Project project) {
        Query projectIssuesQuery = JqlQueryBuilder.newBuilder().where().project(new Long[]{project.getId()}).buildQuery();
        try {
            return this.searchProvider.searchCount(projectIssuesQuery, this.jiraAuthenticationContext.getUser());
        }
        catch (SearchException e) {
            log.warn((Object)("An error occurred trying to determine how many issues in project '" + project.getKey() + "': " + e.getMessage()));
            return 0L;
        }
    }
}

