/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.release;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.page.release.VersionService;
import com.atlassian.jira.projects.page.release.VersionToVersionViewTransformer;
import com.atlassian.jira.projects.page.release.VersionView;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionsJsonableProvider {
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    private final VersionService versionService;
    private final VersionToVersionViewTransformer versionToVersionView;

    @Autowired
    public VersionsJsonableProvider(@ComponentImport JaxbJsonMarshaller jaxbJsonMarshaller, VersionService versionService, VersionToVersionViewTransformer versionToVersionView) {
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
        this.versionService = versionService;
        this.versionToVersionView = versionToVersionView;
    }

    public Jsonable getAllVersions(final Project project) {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                writer.append(VersionsJsonableProvider.this.jaxbJsonMarshaller.marshal((Object)VersionsJsonableProvider.this.getVersions(project)));
            }
        };
    }

    private List<VersionView> getVersions(Project project) {
        List versions = (List)this.versionService.getVersions(project).getOrElse((Object)ImmutableList.of());
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)versions, (Function)this.versionToVersionView));
    }
}

