/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.release;

import com.atlassian.jira.projects.api.service.ReleaseReportVisitsService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.module.propertyset.PropertySet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ReleaseReportsService
implements ReleaseReportVisitsService {
    static final String RELEASE_REPORT_VISITED = "jira.projects.release.report.visited";
    private static final String DEV_INTEGRATION_PLUGIN_KEY = "com.atlassian.jira.plugins.jira-development-integration-plugin";
    private final PluginAccessor pluginAccessor;
    private final UserPropertyManager propertyManager;
    private final JiraAuthenticationContext authenticationContext;

    @Autowired
    public ReleaseReportsService(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport UserPropertyManager propertyManager, @ComponentImport JiraAuthenticationContext authenticationContext) {
        this.pluginAccessor = pluginAccessor;
        this.propertyManager = propertyManager;
        this.authenticationContext = authenticationContext;
    }

    public boolean hasBeenVisitedByCurrentUser() {
        if (this.pluginAccessor.isPluginEnabled(DEV_INTEGRATION_PLUGIN_KEY) && this.authenticationContext.isLoggedInUser()) {
            PropertySet propertySet = this.propertyManager.getPropertySet(this.authenticationContext.getLoggedInUser());
            return propertySet.exists(RELEASE_REPORT_VISITED) && propertySet.getBoolean(RELEASE_REPORT_VISITED);
        }
        return true;
    }

    public void markAsVisitedByCurrentUser() {
        if (this.authenticationContext.isLoggedInUser()) {
            PropertySet propertySet = this.propertyManager.getPropertySet(this.authenticationContext.getLoggedInUser());
            propertySet.setBoolean(RELEASE_REPORT_VISITED, true);
        }
    }
}

