/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.components;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.plugin.webfragment.JiraWebContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.page.components.ComponentService;
import com.atlassian.jira.projects.util.ProjectPermissions;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.List;
import java.util.Map;

public class ComponentsDefinedAndVisibleCondition
implements Condition {
    private final ProjectService projectService;
    private final ComponentService componentService;
    private final ProjectPermissions projectPermissions;

    public ComponentsDefinedAndVisibleCondition(ProjectService projectService, ComponentService componentService, ProjectPermissions projectPermissions) {
        this.projectService = projectService;
        this.componentService = componentService;
        this.projectPermissions = projectPermissions;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        String projectKey = (String)context.get("projectKey");
        Either<ErrorCollection, Project> project = this.projectService.getProject(projectKey);
        if (project.isRight()) {
            Option<List<ProjectComponent>> components = this.componentService.getComponents((Project)project.right().get());
            return components.isDefined() && !((List)components.get()).isEmpty();
        }
        return false;
    }

    private boolean hasProjectAdminPermissions(Map<String, Object> context, Project project) {
        ApplicationUser user = this.getApplicationUser(context);
        return this.projectPermissions.hasProjectAdminPermission(user, project);
    }

    private ApplicationUser getApplicationUser(Map<String, Object> context) {
        return JiraWebContext.from(context).getUser().orElse(null);
    }
}

