/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.view.GadgetViewFactory;
import com.atlassian.gadgets.view.ModuleId;
import com.atlassian.gadgets.view.View;
import com.atlassian.gadgets.view.ViewType;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.streams.spi.ActivityProviderModuleDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@Scanned
public class ProjectActivityStreamContextProvider
implements ContextProvider {
    private static final Logger log = Logger.getLogger(ProjectActivityStreamContextProvider.class);
    private static final String PREF_IS_CONFIGURED = "isConfigured";
    private static final String PREF_RULES = "rules";
    private static final String GADGET_URI = "rest/gadgets/1.0/g/com.atlassian.streams.streams-jira-plugin/gadgets/activitystream-gadget.xml";
    private static final String PREF_NUMOFENTRIES = "numofentries";
    private static final String NUMOFENTRIES = "10";
    private static final String PREFS_IS_CONFIGURABLE = "isConfigurable";
    private static final String PREF_TITLE_REQUIRED = "titleRequired";
    private final PluginAccessor pluginAccessor;
    private final GadgetViewFactory gadgetViewFactory;
    private final GadgetRequestContextFactory gadgetRequestContextFactory;

    public ProjectActivityStreamContextProvider(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport GadgetViewFactory gadgetViewFactory, @ComponentImport GadgetRequestContextFactory gadgetRequestContextFactory) {
        this.pluginAccessor = pluginAccessor;
        this.gadgetViewFactory = gadgetViewFactory;
        this.gadgetRequestContextFactory = gadgetRequestContextFactory;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        String projectKey = (String)context.get("projectKey");
        return MapBuilder.newBuilder(context).add((Object)"gadgetHtml", (Object)this.getGadgetHtml(projectKey)).toMap();
    }

    private String getGadgetHtml(String projectKey) {
        MapBuilder prefsBuilder = MapBuilder.newBuilder();
        prefsBuilder.add((Object)PREF_IS_CONFIGURED, (Object)Boolean.TRUE.toString());
        prefsBuilder.add((Object)PREFS_IS_CONFIGURABLE, (Object)Boolean.FALSE.toString());
        prefsBuilder.add((Object)PREF_RULES, (Object)this.getJiraOnlyRulesJson(projectKey));
        prefsBuilder.add((Object)PREF_NUMOFENTRIES, (Object)NUMOFENTRIES);
        prefsBuilder.add((Object)PREF_TITLE_REQUIRED, (Object)Boolean.FALSE.toString());
        GadgetState gadget = GadgetState.gadget((GadgetId)GadgetId.valueOf((String)"1")).specUri(URI.create(GADGET_URI)).userPrefs(prefsBuilder.toMap()).build();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter gadgetWriter = new OutputStreamWriter(baos);
            GadgetRequestContext requestContext = this.gadgetRequestContextFactory.get(ExecutingHttpRequest.get());
            View settings = new View.Builder().viewType(ViewType.DEFAULT).writable(false).build();
            this.gadgetViewFactory.createGadgetView(gadget, ModuleId.valueOf((long)1L), settings, requestContext).writeTo((Writer)gadgetWriter);
            ((Writer)gadgetWriter).flush();
            return baos.toString();
        }
        catch (IOException e) {
            log.error((Object)"Error rendering activity stream gadget.", (Throwable)e);
        }
        catch (RuntimeException e) {
            log.error((Object)"Runtime error rendering activity stream gadget.", (Throwable)e);
        }
        return "";
    }

    private String getJiraOnlyRulesJson(String projectKey) {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ActivityProviderModuleDescriptor.class);
        ArrayList<Provider> providers = new ArrayList<Provider>();
        providers.add(new Provider("streams", new Rule("key", "is", Arrays.asList(projectKey), "select")));
        providers.add(new DisabledProvider("dud", new Rule[0]));
        for (ActivityProviderModuleDescriptor descriptor : descriptors) {
            providers.add(new Provider(descriptor.getKey(), new Rule[0]));
        }
        Rules rules = new Rules(providers);
        return rules.toJSONObject().toString();
    }

    private static JSONArray listToJSONArray(List<? extends JsonObjectable> list) {
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>(list.size());
        for (JsonObjectable jsonObjectable : list) {
            jsonObjects.add(jsonObjectable.toJSONObject());
        }
        return new JSONArray(jsonObjects);
    }

    private static class Rule
    implements JsonObjectable {
        private final String rule;
        private final String operator;
        private final List<String> value;
        private final String type;

        public Rule(String rule, String operator, List<String> value, String type) {
            this.rule = rule;
            this.operator = operator;
            this.value = value;
            this.type = type;
        }

        @Override
        public JSONObject toJSONObject() {
            Map map = MapBuilder.newBuilder().add((Object)"rule", (Object)this.rule).add((Object)"operator", (Object)this.operator).add((Object)"value", (Object)new JSONArray(this.value)).add((Object)"type", (Object)this.type).toMap();
            return new JSONObject(map);
        }
    }

    private static class DisabledProvider
    extends Provider {
        private DisabledProvider(String provider, Rule ... rules) {
            super(provider, rules);
        }

        @Override
        public JSONObject toJSONObject() {
            Map map = MapBuilder.newBuilder(this.toMap()).add((Object)"disabled", (Object)true).toMap();
            return new JSONObject(map);
        }
    }

    private static class Provider
    implements JsonObjectable {
        protected final String provider;
        protected final List<Rule> rules;

        public Provider(String provider, Rule ... rules) {
            this.provider = provider;
            this.rules = Arrays.asList(rules);
        }

        public Map<String, Object> toMap() {
            return MapBuilder.newBuilder().add((Object)"provider", (Object)this.provider).add((Object)ProjectActivityStreamContextProvider.PREF_RULES, (Object)ProjectActivityStreamContextProvider.listToJSONArray(this.rules)).toMap();
        }

        @Override
        public JSONObject toJSONObject() {
            return new JSONObject(this.toMap());
        }
    }

    private static class Rules
    implements JsonObjectable {
        private final List<Provider> providers;

        private Rules(List<Provider> providers) {
            this.providers = providers;
        }

        @Override
        public JSONObject toJSONObject() {
            Map map = MapBuilder.newBuilder().add((Object)"providers", (Object)ProjectActivityStreamContextProvider.listToJSONArray(this.providers)).toMap();
            return new JSONObject(map);
        }
    }

    private static interface JsonObjectable {
        public JSONObject toJSONObject();
    }
}

