/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy;

import com.atlassian.fugue.Option;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class LegacyProjectTabToSidebarItemTransformer {
    private static final String LEGACY_PROJECT_TAB_PREFIX = "com.atlassian.jira.plugin.system.project:";
    private static final String SIDEBAR_ITEM_PREFIX = "com.atlassian.jira.jira-projects-plugin:";
    private static final Map<String, String> PROJECT_TAB_TO_SIDEBAR_ITEM_IDS = new HashMap<String, String>();
    private static final Map<String, String> SIDEBAR_ITEM_IDS_TO_PROJECT_TABS;

    public Option<String> transformToSidebarItem(@Nullable String legacyProjectTab) {
        return Option.option((Object)this.getEquivalentSidebarItem(legacyProjectTab));
    }

    public Option<String> transformToProjectTab(@Nullable String sidebarItemId) {
        return Option.option((Object)this.getEquivalentProjectTab(sidebarItemId));
    }

    private String getEquivalentSidebarItem(String legacyProjectTab) {
        String sidebarItem = legacyProjectTab;
        if (this.hasEquivalentSidebarItem(legacyProjectTab)) {
            sidebarItem = this.applySidebarItemSuffix(this.applySidebarItemPrefix(legacyProjectTab));
        }
        return StringUtils.stripToNull((String)sidebarItem);
    }

    private String getEquivalentProjectTab(String sidebarItemId) {
        String projectTab = sidebarItemId;
        if (this.hasEquivalentProjectTab(sidebarItemId)) {
            projectTab = this.applyProjectTabSuffix(sidebarItemId);
        }
        return StringUtils.stripToNull((String)projectTab);
    }

    private boolean hasEquivalentSidebarItem(String legacyProjectTab) {
        return this.canBeMappedToSomething(legacyProjectTab, PROJECT_TAB_TO_SIDEBAR_ITEM_IDS);
    }

    private boolean hasEquivalentProjectTab(String sidebarItemId) {
        return this.canBeMappedToSomething(sidebarItemId, SIDEBAR_ITEM_IDS_TO_PROJECT_TABS);
    }

    private boolean canBeMappedToSomething(final String candidateKey, Map<String, String> map) {
        return Iterables.any(map.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String mapKey) {
                return StringUtils.endsWith((CharSequence)candidateKey, (CharSequence)mapKey);
            }
        });
    }

    private String applySidebarItemPrefix(@Nullable String legacyProjectTab) {
        if (StringUtils.startsWith((CharSequence)legacyProjectTab, (CharSequence)LEGACY_PROJECT_TAB_PREFIX)) {
            return StringUtils.replaceOnce((String)legacyProjectTab, (String)LEGACY_PROJECT_TAB_PREFIX, (String)SIDEBAR_ITEM_PREFIX);
        }
        return legacyProjectTab;
    }

    private String applyProjectTabSuffix(String sidebarItemId) {
        return this.applySuffix(sidebarItemId, SIDEBAR_ITEM_IDS_TO_PROJECT_TABS);
    }

    private String applySidebarItemSuffix(@Nullable String legacyProjectTab) {
        return this.applySuffix(legacyProjectTab, PROJECT_TAB_TO_SIDEBAR_ITEM_IDS);
    }

    private String applySuffix(@Nullable String string, Map<String, String> map) {
        for (String key : map.keySet()) {
            if (!StringUtils.endsWith((CharSequence)string, (CharSequence)key)) continue;
            String suffix = map.get(key);
            return StringUtils.replaceOnce((String)string, (String)key, (String)suffix);
        }
        return string;
    }

    static {
        PROJECT_TAB_TO_SIDEBAR_ITEM_IDS.put("summary-panel", "summary-page");
        PROJECT_TAB_TO_SIDEBAR_ITEM_IDS.put("components-panel", "components-page");
        PROJECT_TAB_TO_SIDEBAR_ITEM_IDS.put("versions-panel", "release-page");
        PROJECT_TAB_TO_SIDEBAR_ITEM_IDS.put("reports-panel", "report-page");
        SIDEBAR_ITEM_IDS_TO_PROJECT_TABS = new HashMap<String, String>();
        SIDEBAR_ITEM_IDS_TO_PROJECT_TABS.put("summary-page", "summary-panel");
        SIDEBAR_ITEM_IDS_TO_PROJECT_TABS.put("components-page", "components-panel");
        SIDEBAR_ITEM_IDS_TO_PROJECT_TABS.put("release-page", "versions-panel");
        SIDEBAR_ITEM_IDS_TO_PROJECT_TABS.put("report-page", "reports-panel");
    }
}

