/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.context;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.URLEncoder;
import com.atlassian.jira.projects.api.context.ProjectContextPopulator;
import com.atlassian.jira.projects.module.ProjectScopeFilterContextProviderModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ProjectContextPopulatorImpl
implements ProjectContextPopulator {
    public static final String PATH_ENCODED_PROJECT_KEY = "pathEncodedProjectKey";
    public static final String QUERY_ENCODED_PROJECT_KEY = "queryEncodedProjectKey";
    public static final String ENCODED_PROJECT_KEY = "projectKeyEncoded";
    public static final String PROJECT = "project";
    public static final String PROJECT_KEY = "projectKey";
    public static final String SETTINGS_URL = "settingsUrl";
    private static final String REQUEST_CACHE_KEY = "jira.projects.context.cache";
    private final PluginAccessor pluginAccessor;

    @Autowired
    public ProjectContextPopulatorImpl(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public Map<String, Object> populateWithProject(Map<String, Object> base, Project project) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (base != null) {
            result.putAll(base);
        }
        if (project != null) {
            result.putAll(this.populateWithProject(project));
        }
        return result;
    }

    public Map<String, Object> populateWithProject(Project project) {
        if (project == null) {
            return new HashMap<String, Object>();
        }
        Map requestCache = JiraAuthenticationContextImpl.getRequestCache();
        if (!requestCache.containsKey(REQUEST_CACHE_KEY)) {
            HashMap<String, Object> projectContext = new HashMap<String, Object>();
            projectContext.put(PROJECT, project);
            projectContext.put(PROJECT_KEY, project.getKey());
            projectContext.put(PATH_ENCODED_PROJECT_KEY, URLEncoder.encodePathSegment(project.getKey()));
            projectContext.put(ENCODED_PROJECT_KEY, URLEncoder.encodePathSegment(project.getKey()));
            projectContext.put(QUERY_ENCODED_PROJECT_KEY, URLEncoder.encodeQueryStringValue(project.getKey()));
            projectContext.put(SETTINGS_URL, "/plugins/servlet/project-config/" + URLEncoder.encodePathSegment(project.getKey()));
            List scopeFilterContexts = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectScopeFilterContextProviderModuleDescriptor.class);
            for (ProjectScopeFilterContextProviderModuleDescriptor scopeFilterContext : scopeFilterContexts) {
                projectContext.putAll(scopeFilterContext.getModule().getContext(project));
            }
            requestCache.put(REQUEST_CACHE_KEY, projectContext);
        }
        return (Map)requestCache.get(REQUEST_CACHE_KEY);
    }
}

