define('jira/projectissuenavigator/services/metrics', ['require'], function (require) {
    "use strict";

    var metrics = require('internal/browser-metrics');

    return {

        /**
         * Signifies that the issue view has started in "issue only" mode, as opposed to "issue details" mode. Use this
         * function for single-page-app queries so you don't report data from page load time and instead from when this
         * function is called.
         */
        startIssueView: function() {
            metrics.start({
                key: "jira.project.issue.view-issue"
            });
        },

        /**
         * Signifies an issue search has started. Originally this only applies to project issue search but may
         * potentially apply to global search in future should we combine them. Use this function for single-page-app
         * queries so you don't report data from page load time and instead from when this function is called.
         */
        startIssueSearch: function () {
            metrics.start({
                key: "jira.project.issue.nav-detail"
            });
        },

        /**
         * Signifies that the issue view has started in "issue only" mode, as opposed to "issue details" mode.
         * Use this function on initial page load to get the most accurate metrics.
         */
        startIssueViewFromPageLoad: function() {
            metrics.start({
                key: "jira.project.issue.view-issue",
                isInitial: true,
                ready: [
                    {selector: "#key-val", requireUpdate: false},
                    ".issue-body-content"
                ]
            });
        },

        /**
         * Signifies an issue search has started. Originally this only applies to project issue search but may
         * potentially apply to global search in future should we combine them. Use this function on initial page load
         * to get the most accurate metrics.
         */
        startIssueSearchFromPageLoad: function () {
            metrics.start({
                key: "jira.project.issue.nav-detail",
                isInitial: true
            });
        },

        /**
         * Signal that the issue view painting has completed. Potential times you may want to use this are upon issue
         * view rendering completion or upon completion of issue inline editor initialisation. This function must be
         * paired with a preceding startIssueView or startIssueViewFromPageLoad call and can only be used once for each
         * such call.
         */
        endIssueView: function() {
            metrics.end({
                key: "jira.project.issue.view-issue"
            });
        },

        /**
         * Signal that the issue search painting has completed. This function must be paired with a preceding
         * startIssueSearch or startIssueSearchFromPageLoad call and can only be used once for each such call.
         */
        endIssueSearch: function () {
            metrics.end({
                key: "jira.project.issue.nav-detail"
            });
        }
    };
});
