define("jira/projectissuenavigator/services/linkscapturer", ['require'], function (require) {
    "use strict";

    var jQuery = require('jquery');
    var _ = require('jira/projectissuenavigator/libs/underscore');
    var Marionette = require('jira/projectissuenavigator/libs/marionette');

    return Marionette.Object.extend({
        initialize: function(options) {
            options = options || {};
            this.el = jQuery(options.el);

            this.linkHandler = _.bind(function() {
                this.trigger("linkToFullIssueNavigator");
            }, this);
            this.linkToFullIssueNavigator();
        },

        linkToFullIssueNavigator: function() {
            this.el.on("click", "#full-issue-navigator", this.linkHandler);
        },

        destroy: function() {
            this.el.off("click", "#full-issue-navigator", this.linkHandler);
        }
    });
});
