define("jira/projectissuenavigator/services/jiraevents", ["require"], function(require) {
    "use strict";

    var Events = require('jira/util/events');
    var JiraEventTypes = require('jira/util/events/types');
    var IssueEventTypes = require('jira/components/issueviewer/eventtypes');
    var EventReasons = require('jira/util/events/reasons');
    var jQuery = require('jquery');
    var Marionette = require("jira/projectissuenavigator/libs/marionette");

    return Marionette.Object.extend({
        initialize: function() {
            this.deferredEvents = [];
            this.isDeferring = true;

            jQuery(function() {
                setTimeout(this._drainDeferredEvents.bind(this), 0);
            }.bind(this));
        },

        triggerNewContentAddedFromPanelRefreshed: function(element) {
            this.trigger(JiraEventTypes.NEW_CONTENT_ADDED, [jQuery(element), EventReasons.panelRefreshed]);
        },

        triggerRefreshIssuePage: function(issueId) {
            this.trigger(IssueEventTypes.ISSUE_REFRESHED, [issueId]);
        },

        triggerNewContentAddedFromPageLoad: function(element) {
            this.trigger(JiraEventTypes.NEW_CONTENT_ADDED, [jQuery(element), EventReasons.pageLoad]);
        },

        triggerRefreshToggleBlocks: function(issueId) {
            this.trigger(JiraEventTypes.REFRESH_TOGGLE_BLOCKS, [issueId]);
        },

        triggerPanelRefreshed: function(panelId, $ctx, $existing) {
            this.trigger(IssueEventTypes.PANEL_REFRESHED, [panelId, $ctx, $existing]);
        },

        _drainDeferredEvents: function() {
            this.isDeferring = false;
            this.deferredEvents.forEach(function(eventInfo) {
                this.trigger(eventInfo[0], eventInfo[1]);
            }.bind(this));
            this.deferredEvents.length = 0;
        },

        trigger: function(type, payload) {
            if (this.isDeferring) {
                this.deferredEvents.push([type, payload]);
            } else {
                Events.trigger(type, payload);
            }
        }
    });
});
