AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test", function() {
    "use strict";

    require([
        "jira/projectissuenavigator/services/jiraevents",
        'jira/util/events'
    ], function(
        JiraEvents,
        Events
    ) {
        module("jira/projectissuenavigator/services/jiraevents", {
            setup: function () {
                this.sandbox = sinon.sandbox.create();
                this.clock = this.sandbox.useFakeTimers();
                this.mockedjQuery = this.sandbox.stub();

                this.context = AJS.test.mockableModuleContext();
                this.context.mock('jquery', this.mockedjQuery);
                this.context.mock('jira/util/events', Events);
                this.jiraEvents = new (this.context.require('jira/projectissuenavigator/services/jiraevents'));
            },

            teardown: function () {
                this.sandbox.restore();
            },

            simulateDCL: function() {
                this.mockedjQuery.lastCall.args[0].call(null);
                this.clock.tick(1);
            }
        });

        test("Before DCL, it queues the event and triggres it after DCL", function() {
            var spy = this.spy();
            Events.bind("anEvent", spy);

            this.jiraEvents.trigger("anEvent", "payload");

            sinon.assert.notCalled(spy);

            this.simulateDCL();

            sinon.assert.calledOnce(spy);
            sinon.assert.calledWith(spy, sinon.match.any, "payload");
        });

        test("After DCL, it triggers the event immediately", function() {
            var spy = this.spy();
            Events.bind("anEvent", spy);
            this.simulateDCL();

            this.jiraEvents.trigger("anEvent", "payload");

            sinon.assert.calledOnce(spy);
            sinon.assert.calledWith(spy, sinon.match.any, "payload");
        });

        test("In the very unlikely event of a double DCL, it doesn't trigger the events twice", function() {
            var spy = this.spy();
            Events.bind("anEvent", spy);

            this.simulateDCL();
            this.jiraEvents.trigger("anEvent", "payload");
            this.simulateDCL();

            sinon.assert.calledOnce(spy);
            sinon.assert.calledWith(spy, sinon.match.any, "payload");
        });

    });
});
