AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test", function() {
    "use strict";

    require([
        "jira/projectissuenavigator/services/focusshifter"
    ], function(
        FocusShifter
    ) {
        var IssueEditor = JIRA.Components.IssueEditor;
        var Shifter = JIRA.Shifter;

        module("jira/projectissuenavigator/services/focusshifter", {
            setup: function () {
                this.fields = new IssueEditor.Collections.Fields([]);
                this.mockIssueEditor = {
                    getFields: sinon.stub().returns(this.fields),
                    getIssueKey: sinon.stub().returns("DEMO-123"),
                    editField: sinon.stub()
                };
                this.sandbox = sinon.sandbox.create();
            },

            teardown: function () {
                this.sandbox.restore();
            },

            getItemsRegisteredByFocusShifter: function(fields) {
                // This method would be much more readable if sinon.yields() had a way to capture the result
                // of the callback.
                this.mockIssueEditor.getFields.returns(new IssueEditor.Collections.Fields(fields));

                this.sandbox.stub(Shifter, "register").returnsArg(0);
                this.focusShifter = new FocusShifter(this.mockIssueEditor);
                var itemsFactory = Shifter.register.returnValues[0];

                return itemsFactory();
            }
        });

        test("When initialised, it registers the field options with the JIRA Focus Shifter", function() {
            this.spy(Shifter, "register");

            new FocusShifter(this.mockIssueEditor);

            sinon.assert.calledOnce(Shifter.register);
        });

        test("It returns a group of actions with the right values", function() {
            var elements = this.getItemsRegisteredByFocusShifter();

            equal(elements.id, 'edit-fields');
            equal(elements.weight, 100);
            equal(elements.context, "DEMO-123");
        });

        test("It returns a promise with the editable fields", function() {
            var editorFields = [
                { id: "field1", editHtml: '<div><textarea></textarea></div>', label: 'Field 1' },
                { id: "field2", editHtml: '<div><textarea></textarea></div>', label: 'Field 2' },
                { id: "field3", editHtml: '<div></div>', label: 'Non editable Field' }
            ];
            var elements = this.getItemsRegisteredByFocusShifter(editorFields);

            elements.getSuggestions().done(function(fields) {
                deepEqual(fields, [
                    {label: 'Field 1', value: 'field1'},
                    {label: 'Field 2', value: 'field2'}
                ]);
            });
        });

        test("It does not include the 'comment' field in the results", function() {
            var editorFields = [
                { id: "field1", editHtml: '<div><textarea></textarea></div>', label: 'Field 1' },
                { id: "comment", editHtml: '<div><textarea></textarea></div>', label: 'Comment field' }
            ];
            var elements = this.getItemsRegisteredByFocusShifter(editorFields);

            elements.getSuggestions().done(function(fields) {
                deepEqual(fields, [
                    {label: 'Field 1', value: 'field1'}
                ]);
            });
        });

        test("It edits the field", function() {
            var editorFields = [
                { id: "field1", editHtml: '<div><textarea></textarea></div>', label: 'Field 1' }
            ];
            var elements = this.getItemsRegisteredByFocusShifter(editorFields);

            elements.onSelection('field1');

            sinon.assert.calledOnce(this.mockIssueEditor.editField);
            sinon.assert.calledWith(this.mockIssueEditor.editField, this.mockIssueEditor.getFields().get('field1'));
        });

    });
});
