define("jira/projectissuenavigator/services/analytics", function() {
    "use strict";

    var AJSHelper = require('jira/projectissuenavigator/libs/ajshelper');

    return {
        filterSelect: function(filterData) {
            AJSHelper.trigger('analyticsEvent', {
                name: "jira.project.sidebar.issue.filter.select",
                data: {
                    filterId: filterData.filterId,
                    source: filterData.source
                }
            });
        },

        goToFullIssueNavigator: function() {
            AJSHelper.trigger('analyticsEvent', {
                name: "jira.project.sidebar.issue.load.full.issue.nav"
            });
        },

        expandIssue: function (expandData) {
            AJSHelper.trigger('analyticsEvent', {
                name: "jira.project.sidebar.issue.expand",
                data: {
                    source: expandData.source
                }
            });
        },

        collapseIssue: function (collapseData) {
            AJSHelper.trigger('analyticsEvent', {
                name: "jira.project.sidebar.issue.collapse",
                data: {
                    source: collapseData.source
                }
            });
        },

        issueSelectedInList: function(issueData) {
            AJSHelper.trigger('analyticsEvent', {
                name: "jira.project.sidebar.issue.select.issue",
                data: {
                    issueKey: issueData.key,
                    source: "list",
                    sameProject: true
                }
            });
        },

        triggerProjectNavViewIssue: function(data) {
            AJSHelper.trigger('analyticsEvent', {
                name: "jira.project.sidebar.issue.view.issue",
                data: {
                    issueId: data.issueId,
                    projectId: data.projectId,
                    projectType: data.projectType,
                    issueMatchesProjectContext: data.issueKey == null ? false : data.issueKey.indexOf(data.projectKey + "-") === 0
                }
            });
        },

        manageFilters: function() {
            AJSHelper.trigger('analyticsEvent', {
                name: "jira.project.sidebar.issue.filter.manage"
            });
        },

        pager: function(direction, data) {
            AJSHelper.trigger('analyticsEvent', {
                name: "jira.project.sidebar.issue.pager",
                data: {
                    current: data.current,
                    total: data.total,
                    direction: direction
                }
            });
        },

        editorFieldSaved: function(data) {
            AJSHelper.trigger('analyticsEvent', {
                name: "kickass.inlineEdit",
                data: {
                    issueId: data.issueId,
                    savedFieldIds: data.savedFieldIds,
                    savedFieldTypes: data.savedFieldTypes,
                    source: "jira.projectissuenav.global"
                }
            });
        },

        editFieldStarted: function(data) {
            AJSHelper.trigger('analyticsEvent', {
                name: "kickass.inlineEdit.start",
                data: {
                    issueId: data.issueId,
                    fieldId: data.fieldId,
                    fieldType: data.fieldType,
                    source: "jira.projectissuenav.global"
                }
            });
        },

        editFieldCancelled: function(data) {
            AJSHelper.trigger('analyticsEvent', {
                name: "kickass.inlineEdit.cancel",
                data: {
                    issueId: data.issueId,
                    fieldId: data.fieldId,
                    fieldType: data.fieldType,
                    source: "jira.projectissuenav.global"
                }
            });
        }
    };
});
