define("jira/projectissuenavigator/pages/issueview/views/issue", ['require'], function (require) {
    "use strict";

    var Marionette = require('jira/projectissuenavigator/libs/marionette');
    var Templates = require('jira/projectissuenavigator/pages/issueview/templates');

    return Marionette.LayoutView.extend({
        template: Templates.issueView,

        className: 'wrapper',

        rendered: false,

        ui: {
            collapse: ".collapse"
        },

        regions: {
            issueContainer: ".issue-container",
            pager: ".pager-container"
        },

        triggers: {
            "click @ui.collapse": {
                event: "collapse",
                preventDefault: false,
                stopPropagation: false
            }
        },

        maximizeHeight: function() {
            this.$el.css("height", window.innerHeight - this.$el.offset().top);
        },

        onRender: function() {
            this.ui.collapse.tooltip({
                gravity: 'e'
            });

            // A note on unwrapping:
            //
            // When Marionette/Backbone renders a view, they wrap the template in a <div>. We don't like those extra
            // divs, so we unwrap (i.e. remove the <div>) when we render the template. But we are also attaching views
            // to existing markup without the extra <div>, so we don't want to unwrap it in that case.
            //
            // As this `onRender` method is executed in both cases, we need a mechanism to unwrap on render, but not on
            // attachment. That mechanism is the className. When we render, we add the className to the extra <div>,
            // and `unwrapTemplate` will only unwrap if the className match.
            this.unwrapTemplate(this.className);
            this.rendered = true;
        },

        onDestroy: function() {
            //Destroy could have been called before rendering the View, in that case we won't have this.ui.expand.tooltip
            if (this.ui.collapse.tooltip) {
                this.ui.collapse.tooltip('hide');
            }
        },

        /**
         * Attaches this view to the existing markup
         *
         * @param {HTMLElement|jQuery} el Markup that contains this view
         */
        attach: function(el) {
            this.setElement(el);
            this.bindUIElements();
            this.triggerMethod("render");
        },

        // This Backbone template helper function injects the params of this.options into the template.
        templateHelpers: function() {
            return this.options;
        }
    });
});
