AJS.test.require("com.atlassian.jira.jira-projects-issue-navigator:application-test",function(){require(["jira/components/search","jira/projectissuenavigator/libs/marionette","jira/projectissuenavigator/services/filters","jira/projectissuenavigator/services/urlhelper","jira/projectissuenavigator/services/linkscapturer","jira/projectissuenavigator/libs/uri","jira/projectissuenavigator/services/browser","jira/projectissuenavigator/services/dialogsoverrider","jira/projectissuenavigator/services/metrics","jira/projectissuenavigator/pages/issuesearch/views/empty","jira/components/detailslayout","jira/components/search/results","jira/projectissuenavigator/services/inline-issue-create","jira/util/events","jira/projects/test-utils/marionettemocker","jira/projects/test-utils/mockutils","jira/message","jira/projectissuenavigator/libs/backbone","jquery","jira/projectissuenavigator/libs/underscore","jira/ajs/ajax/smart-ajax","jira/projectissuenavigator/entities/navigatorstate","jira/components/util/events"],function(k,j,x,m,e,l,b,f,h,p,q,g,s,d,t,i,a,c,o,w,u,n,r){var v=JIRA.Projects.Subnavigator;module("jira/projectissuenavigator/pages/issuesearch",{setup:function(){this.sandbox=sinon.sandbox.create();this.sandbox.useFakeServer();this.sandbox.stub(c.history,"start");this.sandbox.stub(b,"locationAssign");this.sandbox.stub(m,"extractProjectKeyFromCurrentUrl").returns("DEMO");this.detailsLayout=t.createEventedMock(this.sandbox,q);this.subnavigator=t.createEventedMock(this.sandbox,v);this.linksCapturer=t.createEventedMock(this.sandbox,e);this.inlineIssueCreate=t.createEventedMock(this.sandbox,s);this.emptyView=t.createEventedMock(this.sandbox,p);this.dialogsOverrider=t.createEventedMock(this.sandbox,f);this.sandbox.stub(x,"getJQL");JIRA.Projects.Subnavigator=this.subnavigator.constructor;this.IssueSearchConstructor=i.spyAll(this.sandbox,i.requireWithMocks("jira/projectissuenavigator/pages/issuesearch",{"jira/components/detailslayout":this.detailsLayout.constructor,"jira/projectissuenavigator/services/urlhelper":m,"jira/projectissuenavigator/services/linkscapturer":this.linksCapturer.constructor,"jira/projectissuenavigator/services/browser":b,"jira/projectissuenavigator/pages/issuesearch/views/empty":this.emptyView.constructor,"jira/projectissuenavigator/services/dialogsoverrider":this.dialogsOverrider.constructor,"jira/util/events":d,"jira/projectissuenavigator/services/metrics":h,"jira/ajs/ajax/smart-ajax":u,"jira/projectissuenavigator/services/inline-issue-create":this.inlineIssueCreate.constructor,"jira/projectissuenavigator/services/filters":x,"jira/message":a}));this.search=this.sandbox.stub(new k());this.search.search.returns(new o.Deferred().promise());this.state=new n();this.issueSearch=new this.IssueSearchConstructor({state:this.state,search:this.search});this.issueSearch.show();this.el=this.issueSearch.el;this.stubErrorFlag()},stubErrorFlag:function(){this.sandbox.stub(u,"buildSimpleErrorContent");this.issueSearch.showErrorFlag.restore();return this.sandbox.stub(this.issueSearch,"showErrorFlag")},teardown:function(){JIRA.Projects.Subnavigator=v;this.sandbox.restore();o(document.body).removeClass("page-type-split page-issue-navigator")},assertState:function(y){w.each(y,function(A,z){if(z===null){ok(!this.state.has(z))}else{equal(this.state.get(z),A,"Internal state for "+z)}}.bind(this))},assertEventTriggered:function(A,B){var z=this.issueSearch.trigger;sinon.assert.calledOnce(z);var y=z.lastCall;equal(y.args[0],A,"The correct event was dispatched");deepEqual(y.args[1],B,"the correct payload was sent")},assertSearch:function(z,y){y=y||this.issueSearch;sinon.assert.calledOnce(y.search);sinon.assert.calledWith(y.search,z)},withSidebarIssueSearchThatCanCreateIssues:function(){var y=new this.IssueSearchConstructor({canCreateIssues:true,router:this.router,state:this.state,search:this.search});y.show();return y}});test("When searching data, it changes the state to represent the load params",function(){this.issueSearch.search({filter:"updatedrecently",issue:"TEMP-123",orderby:"key DESC"});this.assertState({filter:"updatedrecently",issue:"TEMP-123",orderby:"key DESC"})});test("When searching data for the second time, it uses the previous state if none is provided",function(){this.issueSearch.search({filter:"updatedrecently",issue:"TEMP-123",orderby:"key DESC"});this.issueSearch.search({issue:"TEMP-124"});this.assertState({filter:"updatedrecently",issue:"TEMP-124",orderby:"key DESC"})});test("When searching data for the second time, it can erase data from the state if null is provided",function(){this.issueSearch.search({filter:"updatedrecently",issue:"TEMP-123",orderby:"key DESC"});this.issueSearch.search({orderby:null});this.assertState({filter:"updatedrecently",issue:"TEMP-123",orderby:null})});test("When searching data, it does a search using a JQL based on the filter, project and orderby states",function(){this.search.search.returns(new o.Deferred().promise());this.state.set("project","DEMO");x.getJQL.withArgs("updatedrecently","DEMO","key DESC").returns('project = "DEMO" AND updated >= -1w ORDER BY key DESC');this.issueSearch.search({filter:"updatedrecently",orderby:"key DESC"});sinon.assert.calledOnce(this.search.search);sinon.assert.calledWith(this.search.search,'project = "DEMO" AND updated >= -1w ORDER BY key DESC')});test("When searching data, it can jump to a particular startIndex",function(){var y=new g([],{issues:[{id:1,key:"DEMO-1"},{id:2,key:"DEMO-2"},{id:3,key:"DEMO-3"},{id:4,key:"DEMO-4"}]});this.search.search.returns(new o.Deferred().resolve(y).promise());this.issueSearch.search({startIndex:"2"});sinon.assert.calledOnce(this.detailsLayout.load);sinon.assert.calledWith(this.detailsLayout.load,y,"DEMO-3")});test("When searching data, it ignores the startIndex if there is a selected issue",function(){var y=new g([],{issues:[{id:1,key:"DEMO-1"},{id:2,key:"DEMO-2"},{id:3,key:"DEMO-3"},{id:4,key:"DEMO-4"}]});this.search.search.returns(new o.Deferred().resolve(y).promise());this.issueSearch.search({startIndex:"1",issue:"DEMO-4"});sinon.assert.calledOnce(this.detailsLayout.load);sinon.assert.calledWith(this.detailsLayout.load,y,"DEMO-4")});test("When searching data, if the load fails then an error flag is shown and the loading view is hidden",function(){this.search.search.returns(new o.Deferred().reject());this.issueSearch.search();sinon.assert.calledOnce(this.issueSearch.showErrorFlag);sinon.assert.calledOnce(this.detailsLayout.hideLoading)});test("When searching data, if the load fails due to a 400. It should display the first error message in the response",function(){var y="jira.jql.validation.no.such.field";var z={responseText:'{"errorMessages":["'+y+'"]}',status:400};this.search.search.returns(new o.Deferred().reject(z));this.issueSearch.search();sinon.assert.calledOnce(this.issueSearch.showErrorFlag);sinon.assert.calledWith(this.issueSearch.showErrorFlag,y)});test("When searching data, if the load fails due to a timeout. It should display a timeout message.",function(){var y={statusText:u.SmartAjaxResult.TIMEOUT,status:0};this.search.search.returns(new o.Deferred().reject(y));this.issueSearch.search();sinon.assert.calledOnce(this.issueSearch.showErrorFlag);sinon.assert.calledWith(u.buildSimpleErrorContent,y)});test("When the DetailsLayout triggers a 'select' event, the event is re-triggered as 'issue:select'",function(){this.detailsLayout.trigger("select",{key:"TEMP-456"});this.assertEventTriggered("issue:select",{issue:"TEMP-456"})});test("When the DetailsLayout triggers a 'select' event, the issue is updated in the state",function(){this.detailsLayout.trigger("select",{key:"TEMP-456"});this.assertState({issue:"TEMP-456"})});test("When the DetailsLayout triggers a 'empty' event, the event is re-triggered as 'issue:empty'",function(){this.detailsLayout.trigger("empty");this.assertEventTriggered("issue:empty")});test("When the DetailsLayout triggers an 'empty' event, the issue is removed from the state",function(){this.state.set("issue","TEMP-456");this.detailsLayout.trigger("empty");this.assertState({issue:null})});test("When the DetailsLayout triggers a 'list:sort' event, it loads new issues with the new orderby",function(){this.detailsLayout.trigger("list:sort","project = DEMO AND updated >= -1w ORDER BY updated DESC");this.assertSearch({orderby:"updated DESC"})});test("When the DetailsLayout triggers an 'error:loadpage' event, the sidebar issue nav shows an error flag",function(){this.detailsLayout.trigger("error:loadpage");sinon.assert.calledOnce(this.issueSearch.showErrorFlag)});test("When the Subnavigator triggers a 'itemSelected' event, it loads new issues with the new filter and the orderby is cleared",function(){this.subnavigator.trigger("itemSelected",{item:{id:"addedrecently",jql:"reporter = currentUser()"},preventDefault:this.spy()});this.assertSearch({filter:"addedrecently",issue:null,orderby:null})});test("When the detailslayout triggers a 'render' event, an equivalent JIRA event is triggered",function(){var y=this.spy(d,"trigger");this.detailsLayout.trigger("render");sinon.assert.calledOnce(y);sinon.assert.calledWith(y,r.LAYOUT_RENDERED)});test("When a filter is selected in the Subnavigator, it starts recording browser metrics",function(){var y=this.spy(h,"startIssueSearch");var z={item:{id:"addedrecently",jql:"reporter = currentUser()"},preventDefault:this.spy()};this.subnavigator.trigger("itemSelected",z);sinon.assert.calledOnce(y)});test("When a filter is selected in the Subnavigator, it triggers a 'filterSelected' event with the information of the filter",function(){var y=this.spy();this.issueSearch.on("filterSelected",y);var z={item:{id:"addedrecently",jql:"reporter = currentUser()"},preventDefault:this.spy()};this.subnavigator.trigger("itemSelected",z);sinon.assert.calledOnce(y);sinon.assert.calledWith(y,{filterId:"addedrecently",source:"subnavigator"})});test("When the list is sorted in the DetailsLayout, it starts recording browser metrics",function(){var z=this.spy(h,"startIssueSearch");var y="";this.detailsLayout.trigger("list:sort",y);sinon.assert.calledOnce(z)});test("When the list is refreshed in the DetailsLayout, it starts recording browser metrics",function(){var y=this.spy(h,"startIssueSearch");this.detailsLayout.trigger("list:refresh");sinon.assert.calledOnce(y)});test("When an item is selected in the DetailsLayout, it starts recording browser metrics",function(){var y=this.spy(h,"startIssueSearch");var z={};this.detailsLayout.trigger("list:select",z);sinon.assert.calledOnce(y)});test("When the list of issue is paginated in the DetailsLayout, it starts recording browser metrics",function(){var y=this.spy(h,"startIssueSearch");this.detailsLayout.trigger("list:pagination");sinon.assert.calledOnce(y)});test("When an issue is loaded from the cache in the DetailsLayout, it stops recording browser metrics",function(){var y=this.spy(h,"endIssueSearch");var z={};this.detailsLayout.trigger("editorLoadedFromCache",z);sinon.assert.calledOnce(y)});test("When an issue is loaded in the DetailsLayout, it stops recording browser metrics",function(){var y=this.spy(h,"endIssueSearch");var z={};this.detailsLayout.trigger("editorLoaded",z);sinon.assert.calledOnce(y)});test("When an issue is loaded in the DetailsLayout it should pass event.issueEditorOptions.issueRefreshedEvent===true as a issueRefreshedEvent parameter set to true",function(){var y={issueEditorOptions:{issueRefreshedEvent:true}};this.detailsLayout.trigger("editorLoaded",y);sinon.assert.calledOnce(this.issueSearch.trigger);sinon.assert.calledWith(this.issueSearch.trigger,"editorLoaded",{issueRefreshedEvent:true})});test("When an issue is loaded in the DetailsLayout it should pass event.issueEditorOptions.issueRefreshedEvent===false as a issueRefreshedEvent parameter set to false",function(){var y={issueEditorOptions:{issueRefreshedEvent:false}};this.detailsLayout.trigger("editorLoaded",y);sinon.assert.calledOnce(this.issueSearch.trigger);sinon.assert.calledWith(this.issueSearch.trigger,"editorLoaded",{issueRefreshedEvent:false})});test("When an issue is loaded in the DetailsLayout it should pass empty event.issueEditorOptions as a issueRefreshedEvent parameter set to false",function(){var y={};this.detailsLayout.trigger("editorLoaded",y);sinon.assert.calledOnce(this.issueSearch.trigger);sinon.assert.calledWith(this.issueSearch.trigger,"editorLoaded",{issueRefreshedEvent:false})});test("When the next issue is selected, it start recording browser metrics",function(){var y=this.spy(h,"startIssueSearch");this.detailsLayout.trigger("pager:next",{current:1,total:2});sinon.assert.calledOnce(y)});test("When the previous issue is selected, it start recording browser metrics",function(){var y=this.spy(h,"startIssueSearch");this.detailsLayout.trigger("pager:previous",{current:1,total:2});sinon.assert.calledOnce(y)});test("When the next issue is selected, it should trigger an event",function(){var y=this.spy();this.issueSearch.on("pager:next",y);this.detailsLayout.trigger("pager:next",{current:1,total:2});sinon.assert.calledOnce(y)});test("When the previous issue is selected, it should trigger an event",function(){var y=this.spy();this.issueSearch.on("pager:previous",y);this.detailsLayout.trigger("pager:previous",{current:1,total:2});sinon.assert.calledOnce(y)});test("When constructed with an user that can create issues, it ask the DetailsLayout to display the IIC",function(){this.withSidebarIssueSearchThatCanCreateIssues();equal(this.detailsLayout.constructor.lastCall.args[0].displayInlineIssueCreate,true)});test("When constructed with an user that can create issues, it ask the DetailsLayout to display the IIC",function(){this.withSidebarIssueSearchThatCanCreateIssues();equal(this.detailsLayout.constructor.lastCall.args[0].displayInlineIssueCreate,true)});test("When an issue is created in the DetailsLayout and the current filter supports inline issue creation, we reload the current filter and select the created issue",function(){this.stub(x,"filterSupportsInlineIssueCreate").withArgs("aFilterId").returns(true);var y=this.withSidebarIssueSearchThatCanCreateIssues();this.state.set("project","DEMO");y.search({filter:"aFilterId",issue:"DEMO-1"});y.search.reset();this.detailsLayout.trigger("issueCreated",{issue:{issueKey:"DEMO-2"},fields:{summary:"This is a test"}});this.assertSearch({issue:"DEMO-2"},y);this.assertState({filter:"aFilterId",issue:"DEMO-2",project:"DEMO"},y)});test("When an issue is created in the DetailsLayout and the current filter does not support inline issue creation, we show a flag",function(){this.stub(x,"filterSupportsInlineIssueCreate").withArgs("aFilterId").returns(false);this.stub(a,"showSuccessMsg");this.state.set("project","DEMO");var y=this.withSidebarIssueSearchThatCanCreateIssues();y.search({filter:"aFilterId",issue:"DEMO-1"});y.search.reset();this.detailsLayout.trigger("issueCreated",{issue:{issueKey:"DEMO-2"},fields:{summary:"This is a test"}});sinon.assert.notCalled(y.search);this.assertState({filter:"aFilterId",issue:"DEMO-1",project:"DEMO"},y);sinon.assert.calledOnce(a.showSuccessMsg)});test("When the DetailsLayout triggers a 'empty' event, if the IIC mode is enabled whe display the IIC widget",function(){var A=o("<div></div>");var y="project=DEMO";var z=this.withSidebarIssueSearchThatCanCreateIssues();this.emptyView.inlineIssueCreateContainer=new j.Region({el:A});z.emptyView=this.emptyView;this.state.set("searchResults",new g([],{jql:y}));this.detailsLayout.trigger("empty");sinon.assert.calledOnce(this.inlineIssueCreate.show);sinon.assert.calledWith(this.inlineIssueCreate.show,this.emptyView.inlineIssueCreateContainer.$el)});test("When the DetailsLayout triggers a 'empty' event, if the IIC is activated with the results JQL",function(){var A=o("<div></div>");var y="project=DEMO";var z=this.withSidebarIssueSearchThatCanCreateIssues();this.emptyView.inlineIssueCreateContainer=new j.Region({el:A});z.emptyView=this.emptyView;this.state.set("searchResults",new g([],{jql:y}));this.detailsLayout.trigger("empty");sinon.assert.calledOnce(this.inlineIssueCreate.activateWithJQL);sinon.assert.calledWith(this.inlineIssueCreate.activateWithJQL,y)});test("When searching data and we correct the filter, it triggers a 'filterSelected' event with the information of the new filter",function(){var z=this.spy();this.issueSearch.on("filterSelected",z);var y=new g([],{issues:[{id:1,key:"DEMO-1"},{id:2,key:"DEMO-2"}],jql:'project = "DEMO" AND updated >= -1w ORDER BY key DESC'});this.search.search.returns(new o.Deferred().resolve(y).promise());this.issueSearch.search({filter:"updatedrecently",issue:"DEMO-3"});sinon.assert.calledOnce(z);sinon.assert.calledWith(z,{filterId:"allissues",source:"issueFilterMismatch"})});test("When the user select the Manage Filters in the subnavigator, it doesn't change the title'",function(){var y=this.el.find("#issues-subnavigation-title");y.text("Open issues");this.subnavigator.trigger("itemSelected",{item:{id:"manage",jql:true},preventDefault:function(){}});equal(y.text(),"Open issues")});test("When the user selects any other filter in the subnavigator, it changes the title'",function(){var y=this.el.find("#issues-subnavigation-title");y.text("Open issues");this.issueSearch.subnavigation.trigger("itemSelected",{item:{id:"allopenissues",jql:true},preventDefault:function(){}});equal(y.text(),"")});test("When the user select the Manage Filters in the subnavigator, it triggers the event 'manageFilters'",function(){var y=this.spy();this.issueSearch.on("manageFilters",y);this.subnavigator.trigger("itemSelected",{item:{id:"manage"}});sinon.assert.calledOnce(y)});test("When the DialogsOverrider is constructed, it is provided with the correct callbacks",function(){sinon.assert.calledOnce(this.dialogsOverrider.constructor);var y=this.dialogsOverrider.constructor.args[0][0];this.detailsLayout.getActiveIssueId.returns(1);equal(y.getIssueId(),1);var z={};z.$activeTrigger={};z.$activeTrigger.data=sinon.stub();z.$activeTrigger.data.withArgs("issueid").returns(2);equal(y.getIssueId(z),2);this.detailsLayout.getActiveIssueKey.returns("KEY-1");equal(y.getIssueKey(),"KEY-1");z.$activeTrigger.data.withArgs("issuekey").returns("KEY-2");equal(y.getIssueKey(z),"KEY-2")});test("When an issue is removed, it is also removed from the DetailsLayout",function(){this.detailsLayout.removeIssue.returns(new o.Deferred().resolve().promise());this.dialogsOverrider.trigger("issueDelete",{issueId:1});sinon.assert.calledOnce(this.issueSearch.removeIssue);sinon.assert.calledWith(this.issueSearch.removeIssue,1);sinon.assert.calledOnce(this.detailsLayout.removeIssue);sinon.assert.calledWith(this.detailsLayout.removeIssue,1)});test("When the DetailsLayout triggers a 'editor:saveSuccess' event, the event is re-triggered as 'editor:saveSuccess'",function(){this.detailsLayout.trigger("editor:saveSuccess",{event:"123456",savedFieldIds:["fieldId-1"],savedFieldTypes:["fieldType-1"],duration:123});this.assertEventTriggered("editor:saveSuccess",{issueId:"123456",savedFieldIds:["fieldId-1"],savedFieldTypes:["fieldType-1"],duration:123})});test("When the DetailsLayout triggers a 'editor:editField' event, the event is re-triggered as 'editor:editField'",function(){var y={issueId:"123456",issueKey:"TEST-1",fieldId:"field-123",fieldType:"field-type"};this.detailsLayout.trigger("editor:editField",y);this.assertEventTriggered("editor:editField",y)});test("When the DetailsLayout triggers a 'editor:editFieldCancel' event, the event is re-triggered as 'editor:editFieldCancel'",function(){var y={issueId:"123456",issueKey:"TEST-1",fieldId:"field-123",fieldType:"field-type"};this.detailsLayout.trigger("editor:editFieldCancel",y);this.assertEventTriggered("editor:editFieldCancel",y)});test("When focusing the issue list, it delegates the call to the internal DetailsLayout component",function(){this.issueSearch.focusIssueList();sinon.assert.calledOnce(this.detailsLayout.focusList)});test("When focusing the issue editor, it delegates the call to the internal DetailsLayout component",function(){this.issueSearch.focusIssueEditor();sinon.assert.calledOnce(this.detailsLayout.focusEditor)});test("When the DetailsLayout triggers an 'individualPanelRendered' event, it is re-triggered with the same payload",function(){var y={data:123};this.detailsLayout.trigger("individualPanelRendered",y);this.assertEventTriggered("individualPanelRendered",y)});test("When getting the project id, it delegates the call to the internal DetailsLayout component",function(){this.detailsLayout.getActiveProjectId.returns(123);var y=this.issueSearch.getProjectId();sinon.assert.calledOnce(this.detailsLayout.getActiveProjectId);equal(y,123)});test("When getting the project key, it delegates the call to the internal DetailsLayout component",function(){this.detailsLayout.getActiveProjectKey.returns("TEST");var y=this.issueSearch.getProjectKey();sinon.assert.calledOnce(this.detailsLayout.getActiveProjectKey);equal(y,"TEST")});test("When getting the project type, it delegates the call to the internal DetailsLayout component",function(){this.detailsLayout.getActiveProjectType.returns("software");var y=this.issueSearch.getProjectType();sinon.assert.calledOnce(this.detailsLayout.getActiveProjectType);equal(y,"software")})})});