/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator.helpers;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.filter.ProjectSearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.issuenavigator.filter.AllFieldsInOrderByClause;
import com.atlassian.jira.projects.issuenavigator.filter.Filter;
import com.atlassian.jira.projects.issuenavigator.filter.GenericFilters;
import com.atlassian.jira.projects.issuenavigator.filter.LoggedInPredicate;
import com.atlassian.jira.projects.issuenavigator.filter.RemoveNonSearchableFieldsFromOrderByFunction;
import com.atlassian.jira.projects.issuenavigator.filter.SearchRequestToFilterFunction;
import com.atlassian.jira.projects.issuenavigator.helpers.FilterLoaderHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.assembler.RequiredData;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;

@Scanned
@Named
public class DefaultFilterLoaderHelper
implements FilterLoaderHelper {
    private static final String PLUGIN_KEY = "com.atlassian.jira.jira-projects-issue-navigator:";
    private static final String CAN_MANAGE_FILTERS_KEY = "com.atlassian.jira.jira-projects-issue-navigator:can-manage-filters";
    private static final String DEFAULT_FILTER_PRIORITY_KEY = "com.atlassian.jira.jira-projects-issue-navigator:default-filter-priority";
    private static final String GENERIC_FILTERS_KEY = "com.atlassian.jira.jira-projects-issue-navigator:generic-filters";
    private static final String PROJECT_FILTERS_KEY = "com.atlassian.jira.jira-projects-issue-navigator:project-filters";
    public static final Set<String> DEFAULT_FILTER_PRIORITY = ImmutableSet.of((Object)"allopenissues", (Object)"allissues");
    private final JiraPageBuilderService jiraPageBuilderService;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    private final I18nResolver i18nResolver;
    private final ProjectSearchRequestService projectSearchRequestService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final FieldLayoutManager fieldLayoutManager;
    private final SearchService searchService;
    private final FieldManager fieldManager;
    private final GenericFilters genericFilters;
    private final Set<String> filterFields;

    @Inject
    public DefaultFilterLoaderHelper(@ComponentImport JiraPageBuilderService jiraPageBuilderService, @ComponentImport JaxbJsonMarshaller jaxbJsonMarshaller, @ComponentImport I18nResolver i18nResolver, @ComponentImport ProjectSearchRequestService projectSearchRequestService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport FieldLayoutManager fieldLayoutManager, @ComponentImport SearchService searchService, @ComponentImport FieldManager fieldManager, GenericFilters genericFilters) {
        this.jiraPageBuilderService = jiraPageBuilderService;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
        this.i18nResolver = i18nResolver;
        this.projectSearchRequestService = projectSearchRequestService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.fieldLayoutManager = fieldLayoutManager;
        this.searchService = searchService;
        this.fieldManager = fieldManager;
        this.genericFilters = genericFilters;
        this.filterFields = Collections.unmodifiableSet(((Map)genericFilters.get()).values().stream().flatMap(x -> Stream.concat(Stream.of(x.getFields()), AllFieldsInOrderByClause.get(x).stream())).collect(Collectors.toSet()));
    }

    @Override
    public List<Filter> loadGenericFilters(Project project) {
        Set projectFieldLayouts = this.fieldLayoutManager.getUniqueFieldLayouts(project);
        Set userFieldLayouts = this.fieldManager.getVisibleFieldLayouts(this.jiraAuthenticationContext.getLoggedInUser());
        Sets.SetView fieldLayouts = Sets.intersection((Set)projectFieldLayouts, (Set)userFieldLayouts);
        List<String> searchableFieldNames = this.filterFields.stream().map(fieldId -> Optional.ofNullable(this.fieldManager.getField(fieldId)).orElseThrow(() -> new RuntimeException("FieldManager can't find field \"" + fieldId + "\""))).filter(arg_0 -> this.lambda$loadGenericFilters$3((Set)fieldLayouts, arg_0)).map(Field::getId).collect(Collectors.toList());
        List<Filter> genericFilters = ((Map)this.genericFilters.get()).values().stream().filter(x -> searchableFieldNames.containsAll(Arrays.asList(x.getFields()))).filter(new LoggedInPredicate<Filter>(this.jiraAuthenticationContext.isLoggedInUser(), Filter::isRequiresUser)).map(new RemoveNonSearchableFieldsFromOrderByFunction(searchableFieldNames)).map(x -> Filter.builder(x).label(this.i18nResolver.getText(x.getLabel())).build()).collect(Collectors.toList());
        RequiredData wrmData = this.jiraPageBuilderService.assembler().data();
        wrmData.requireData(GENERIC_FILTERS_KEY, writer -> writer.write(this.jaxbJsonMarshaller.marshal((Object)genericFilters)));
        wrmData.requireData(DEFAULT_FILTER_PRIORITY_KEY, writer -> writer.append(this.jaxbJsonMarshaller.marshal(DEFAULT_FILTER_PRIORITY)));
        return genericFilters;
    }

    @Override
    public void loadCustomFilters(Project project) {
        List searchRequests = this.projectSearchRequestService.getSearchRequestsForProject(this.jiraAuthenticationContext.getLoggedInUser(), project);
        List filters = (List)searchRequests.stream().map(new SearchRequestToFilterFunction(project, this.searchService)).filter(new LoggedInPredicate<Filter>(this.jiraAuthenticationContext.isLoggedInUser(), Filter::isRequiresUser)).collect(CollectorsUtil.toImmutableList());
        boolean ownsAnySearchRequest = searchRequests.stream().anyMatch(request -> request.getOwner().equals((Object)this.jiraAuthenticationContext.getLoggedInUser()));
        this.jiraPageBuilderService.assembler().data().requireData(CAN_MANAGE_FILTERS_KEY, Boolean.valueOf(ownsAnySearchRequest));
        this.jiraPageBuilderService.assembler().data().requireData(PROJECT_FILTERS_KEY, writer -> writer.append(this.jaxbJsonMarshaller.marshal((Object)filters)));
    }

    private /* synthetic */ boolean lambda$loadGenericFilters$3(Set fieldLayouts, Field x) {
        return !this.fieldManager.isFieldHidden(fieldLayouts, x);
    }
}

