/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator.filter;

import com.atlassian.jira.components.issueviewer.service.SystemFilter;
import com.atlassian.jira.projects.issuenavigator.filter.Filter;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum SystemFilterToFilterFunction implements Function<SystemFilter, Filter>
{
    INSTANCE;

    private static final Pattern FILTER_PATTERN;

    @Override
    public Filter apply(SystemFilter systemFilter) {
        String defaultOrderBy;
        String jql;
        Matcher m = FILTER_PATTERN.matcher(systemFilter.getJql());
        if (m.find()) {
            jql = "project = \"{0}\"" + (m.group(1).trim().length() > 0 ? " AND " + m.group(1) : "") + " ORDER BY {1}";
            defaultOrderBy = m.group(2);
        } else {
            jql = "project = \"{0}\"";
            defaultOrderBy = "";
        }
        return Filter.builder(systemFilter.name().toLowerCase().replace("_", ""), jql, defaultOrderBy, systemFilter.getName()).requiresUser(systemFilter.isRequiresLogin()).supportsInlineIssueCreate(systemFilter.isSupportsInlineIssueCreate()).fields((String[])systemFilter.getFields().stream().toArray(String[]::new)).numericId(systemFilter.getId()).build();
    }

    static {
        FILTER_PATTERN = Pattern.compile("^(.*?)\\s*ORDER BY\\s+(.*?)$", 2);
    }
}

