/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator.filter;

import com.google.common.base.MoreObjects;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Filter {
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final Pattern ORDERBY_PATTERN = Pattern.compile("((\\w+)\\s+(?:DE|A)SC)\\s*,?");
    @XmlElement
    private final String id;
    @XmlElement
    private final Long numericId;
    @XmlElement
    private final String jql;
    @XmlElement
    private final String defaultOrderby;
    @XmlElement
    private final String label;
    @XmlElement
    private final boolean requiresUser;
    @XmlElement
    private final boolean supportsInlineIssueCreate;
    @XmlElement
    private final String[] fields;

    public static Builder builder(String id, String jql, String defaultOrderby, String label) {
        return new Builder(id, jql, defaultOrderby, label);
    }

    public static Builder builder(Filter filter) {
        return new Builder(filter.id, filter.jql, filter.defaultOrderby, filter.label).requiresUser(filter.requiresUser).fields(filter.fields).supportsInlineIssueCreate(filter.supportsInlineIssueCreate);
    }

    private Filter(String id, Long numericId, String jql, String defaultOrderby, String label, boolean requiresUser, boolean supportsInlineIssueCreate, String[] fields) {
        this.id = id;
        this.numericId = numericId;
        this.jql = jql;
        this.defaultOrderby = defaultOrderby;
        this.label = label;
        this.requiresUser = requiresUser;
        this.supportsInlineIssueCreate = supportsInlineIssueCreate;
        this.fields = fields;
    }

    public String getId() {
        return this.id;
    }

    public Long getNumericId() {
        return this.numericId;
    }

    public String getJql() {
        return this.jql;
    }

    public String getDefaultOrderby() {
        return this.defaultOrderby;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isRequiresUser() {
        return this.requiresUser;
    }

    public boolean canSupportInlineIssueCreate() {
        return this.supportsInlineIssueCreate;
    }

    public String[] getFields() {
        return this.fields;
    }

    public static String parseJql(Filter filter, String project, String orderby) {
        return MessageFormat.format(filter.getJql(), project, Objects.equals("", orderby) ? filter.getDefaultOrderby() : orderby);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Filter filter = (Filter)o;
        return Objects.equals(this.requiresUser, filter.requiresUser) && Objects.equals(this.id, filter.id) && Objects.equals(this.jql, filter.jql) && Objects.equals(this.defaultOrderby, filter.defaultOrderby) && Objects.equals(this.label, filter.label);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jql, this.defaultOrderby, this.label, this.requiresUser);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("jql", (Object)this.jql).add("defaultOrderby", (Object)this.defaultOrderby).add("label", (Object)this.label).add("requiresUser", this.requiresUser).add("supportsInlineIssueCreate", this.supportsInlineIssueCreate).add("fields", (Object)this.fields).toString();
    }

    public static class Builder {
        private String id;
        private Long numericId;
        private String jql;
        private String defaultOrderby;
        private String label;
        private boolean requiresUser = false;
        private boolean supportsInlineIssueCreate = false;
        private String[] fields = EMPTY_ARRAY;

        private Builder(String id, String jql, String defaultOrderby, String label) {
            this.id(id);
            this.jql(jql);
            this.defaultOrderby(defaultOrderby);
            this.label(label);
        }

        public Builder requiresUser(boolean flag) {
            this.requiresUser = flag;
            return this;
        }

        public Builder supportsInlineIssueCreate(boolean flag) {
            this.supportsInlineIssueCreate = flag;
            return this;
        }

        public Builder fields(String ... array) {
            this.fields = array;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder jql(String jql) {
            this.jql = jql;
            return this;
        }

        public Builder defaultOrderby(String defaultOrderby) {
            this.defaultOrderby = defaultOrderby;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder numericId(Long numericId) {
            this.numericId = numericId;
            return this;
        }

        public Filter build() {
            return new Filter(this.id, this.numericId, this.jql, this.defaultOrderby, this.label, this.requiresUser, this.supportsInlineIssueCreate, this.fields);
        }
    }
}

