/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator.emptystate;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.project.ProjectPropertiesManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.module.propertyset.PropertySet;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class IssueCreatedInProjectListener
implements InitializingBean,
DisposableBean {
    static final String FIRST_ISSUE_CREATED_KEY = "firstIssueCreated";
    private final EventPublisher eventPublisher;
    private final ProjectPropertiesManager projectPropertiesManager;

    @Inject
    public IssueCreatedInProjectListener(@ComponentImport EventPublisher eventPublisher, @ComponentImport ProjectPropertiesManager projectPropertiesManager) {
        this.eventPublisher = eventPublisher;
        this.projectPropertiesManager = projectPropertiesManager;
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onIssueEvent(IssueEvent event) {
        PropertySet propertySet;
        Long eventTypeId = event.getEventTypeId();
        if (eventTypeId.equals(EventType.ISSUE_CREATED_ID) && !(propertySet = this.projectPropertiesManager.getPropertySet(event.getProject())).exists(FIRST_ISSUE_CREATED_KEY)) {
            propertySet.setBoolean(FIRST_ISSUE_CREATED_KEY, true);
        }
    }
}

