/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator.emptystate;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectPropertiesManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;
import java.util.Optional;

@Scanned
public class IsEmptyProjectCondition
implements Condition {
    private final ProjectPropertiesManager projectPropertiesManager;

    public IsEmptyProjectCondition(@ComponentImport ProjectPropertiesManager projectPropertiesManager) {
        this.projectPropertiesManager = projectPropertiesManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Optional<Project> projectParam = Optional.ofNullable((Project)context.get("project"));
        return projectParam.map(project -> {
            PropertySet propertySet = this.projectPropertiesManager.getPropertySet(project);
            return !propertySet.getBoolean("firstIssueCreated");
        }).orElse(false);
    }
}

