/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator.emptystate;

import com.atlassian.fugue.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;

@Named
public class EmptyStatePanelRenderer {
    private static final String EMPTY_STATE_PANEL_LOCATION = "project.sidebar.issue.navigator.empty.state";
    private static final String PROJECT_CONTEXT_KEY = "project";
    private static final String EMPTY_STATE_WEBRESOURCE_KEY = "com.atlassian.jira.jira-projects-issue-navigator:empty-state-resources";
    private static final String STATIC_RESOURCE_PREFIX = "staticResourcePrefix";
    private WebResourceUrlProvider webResourceUrlProvider;
    private final DynamicWebInterfaceManager webInterfaceManager;

    @Inject
    public EmptyStatePanelRenderer(@ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport DynamicWebInterfaceManager webInterfaceManager) {
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.webInterfaceManager = webInterfaceManager;
    }

    public Optional<String> renderEmptyStatePanels(Project project) {
        String staticResourcePrefix = this.webResourceUrlProvider.getStaticPluginResourceUrl(EMPTY_STATE_WEBRESOURCE_KEY, "", UrlMode.AUTO);
        Map context = MapBuilder.build((Object)PROJECT_CONTEXT_KEY, (Object)project, (Object)STATIC_RESOURCE_PREFIX, (Object)staticResourcePrefix);
        List webPanels = this.webInterfaceManager.getDisplayableWebPanels(EMPTY_STATE_PANEL_LOCATION, context);
        StringBuilder emptyStateHtml = new StringBuilder();
        webPanels.forEach(panel -> {
            Option panelHtml = SafePluginPointAccess.call(() -> panel.getHtml(context));
            emptyStateHtml.append((String)panelHtml.getOrElse((Object)""));
        });
        String html = emptyStateHtml.toString();
        return StringUtils.isBlank((String)html) ? Optional.empty() : Optional.of(html);
    }
}

