/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator;

import com.atlassian.jira.plugin.issuenav.rest.IssueTableResource;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTable;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTableServiceOutcome;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.issuenavigator.PageContextProvider;
import com.atlassian.jira.projects.issuenavigator.filter.Filter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Named
public class IssueSearchDataProvider {
    private static final String ISSUE_SEARCH_DATA_KEY = "com.atlassian.jira.jira-issue-navigator-components:search-data";
    private final IssueTableResource issueTableResource;

    @Inject
    public IssueSearchDataProvider(@ComponentImport IssueTableResource issueTableResource) {
        this.issueTableResource = issueTableResource;
    }

    public Optional<IssueTable> apply(List<Filter> filters, Project project, Optional<String> filterParameter, Optional<String> orderbyParameter, BiConsumer<String, Object> dataConsumer) {
        if (filters.size() == 0) {
            return Optional.empty();
        }
        Set filterIds = filters.stream().map(Filter::getId).collect(Collectors.toSet());
        String filterId = filterParameter.filter(filterIds::contains).orElseGet(() -> PageContextProvider.DEFAULT_FILTER_PRIORITY.stream().filter(filterIds::contains).findFirst().orElse(((Filter)filters.get(0)).getId()));
        String orderby = orderbyParameter.orElse("");
        Filter filter = filters.stream().filter(f -> Objects.equals(f.getId(), filterId)).findFirst().get();
        String jql = Filter.parseJql(filter, project.getKey(), orderby);
        Response restResponse = this.issueTableResource.getIssueTableHtml(null, jql, null, 0, "split-view", "explicit");
        if (restResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            IssueSearchData data = new IssueSearchData();
            data.jql = jql;
            data.response = (IssueTableServiceOutcome)restResponse.getEntity();
            dataConsumer.accept(ISSUE_SEARCH_DATA_KEY, data);
            return Optional.of(data.response.getIssueTable());
        }
        return Optional.empty();
    }

    @XmlRootElement
    public static class IssueSearchData {
        @XmlElement
        IssueTableServiceOutcome response;
        @XmlElement
        String jql;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssueSearchData that = (IssueSearchData)o;
            return Objects.equals(this.response, that.response) && Objects.equals(this.jql, that.jql);
        }

        public int hashCode() {
            return Objects.hash(this.response, this.jql);
        }
    }
}

