ATLAS_PROJECT_CREATE = {};

(function ($) {

    AJS.EventQueue = AJS.EventQueue || [];

    var JIRA_PROJECT_CAPABILITY_KEY = 'jira.project';

    //This will most likely be added to the SPI in future versions
    var CAPABILITY_WEIGHT = {
        "confluence.space" : 30,
        "bamboo.project" : 20,
        "ondemand.svn-repository" : 10
    };

    ATLAS_PROJECT_CREATE.getFilteredRootTypes = function getFilteredRootTypes(response) {
        var types = {};
        for (var key in response.types) {
            if (key !== JIRA_PROJECT_CAPABILITY_KEY) {
                types[key] = response.types[key];
            }
        }
        return types;
    };

    ATLAS_PROJECT_CREATE.loadRemoteRoots = function loadRemoteRoots(capabilities) {
        var deferred = jQuery.Deferred(),
            innerPromises = [],
            rootTypes = [];

        // map each capability to the promise of an ajax call, when they're all done innerpromises will contain an array of promises, one for each
        // inner ajax call made. Once this outer mega-promise is resolved, we can create a new mega-promise out of the contents of innerPromises.
        // Once that mega-promise is resolved we can resolve the outside visible promise (projectCreationPromise), passing in the gathered root types.
        mapToPromise(capabilities,function (capability) {
            var baseUrl = capability.capabilitiesUrl;
            return AJS.$.ajax(baseUrl + '/aggregate-root', {
                success: function (response) {
                    var types = ATLAS_PROJECT_CREATE.getFilteredRootTypes(response);
                    innerPromises = innerPromises.concat(_.map(types, function (type, key) {
                        return AJS.$.ajax(type.href, {
                            xhrFields: {
                                withCredentials: true
                            },
                            success: function (rootType) {
                                rootTypes.push(ATLAS_PROJECT_CREATE.constructFullRootType(rootType, type.label, key, baseUrl, capability.id));
                            },
                            error: function (xhr, status, errorThrown) {
                                AJS.log('Got ' + errorThrown + ' from aggregate root type ' + type.href);
                            }
                        }).promise();
                    }));
                }, error: function (xhr, status, errorThrown) {
                    // TODO ROTP-1146 ROTP-1147: handle 401, 403 better
                    AJS.log('Got ' + errorThrown + ' from aggregate roots capapbility for ' + baseUrl);
                }
            }).promise();
        }).done(function () {
                promiseFromPromiseList(innerPromises).done(function () {
                    deferred.resolve(rootTypes);
                });
            });
        return deferred.promise();
    };

    ATLAS_PROJECT_CREATE.constructFullRootType = function constructFullRootType(rootType, label, capabilityKey, baseUrl, instanceId) {
        return {
            keys: rootType.keys,
            url: rootType.links.self,
            label: label,
            capabilityKey: capabilityKey,
            baseUrl: baseUrl,
            instanceId: instanceId
        };
    };

    ATLAS_PROJECT_CREATE.createLink = function createLink(linkDetails, complete) {
        console.log("creating link from " + linkDetails.entityType + " to " + linkDetails.remoteEntityType);
        var linkRequest = JSON.stringify({
            "local": linkDetails.baseUrl + "/aggregate-root/" + linkDetails.entityType + "/" + linkDetails.entityKey,
            "target": linkDetails.remoteInstanceBaseUrl + "/aggregate-root/" + linkDetails.remoteEntityType + "/" + linkDetails.remoteEntityKey
        });
        AJS.$.ajax(linkDetails.baseUrl + "/aggregate-root-link", {
            type: "POST",
            contentType: "application/json",
            data: linkRequest,
            timeout: 8000,
            complete: complete
        });
    };


    ATLAS_PROJECT_CREATE.linkAllTheThings = function linkAllTheThings(dialog, createdThings, projectKey, projectCreationPage, acknowledgeButton) {

        var linksToCreate = [];
        $.each(createdThings, function createLinks(idx, entity) {
            linksToCreate.push({
                baseUrl: entity.type.baseUrl,
                entityType: entity.type.capabilityKey,
                entityKey: entity.data.key,
                remoteInstanceBaseUrl: getAppBaseUrl() + "/rest/capabilities",
                remoteEntityType: JIRA_PROJECT_CAPABILITY_KEY,
                remoteEntityKey: projectKey
            });

            linksToCreate.push({
                baseUrl: getAppBaseUrl() + "/rest/capabilities",
                entityType: JIRA_PROJECT_CAPABILITY_KEY,
                entityKey: projectKey,
                remoteInstanceBaseUrl: entity.type.baseUrl,
                remoteEntityType: entity.type.capabilityKey,
                remoteEntityKey: entity.data.key
            });

            AJS.$.each(createdThings, function createLinkBetweenRemoteEntities(targetIdx, targetEntity) {
                //first check we are not trying to link something to itself or something else in the same instance
                if (targetEntity !== entity) {
                    linksToCreate.push({
                        baseUrl: entity.type.baseUrl,
                        entityType: entity.type.capabilityKey,
                        entityKey: entity.data.key,
                        remoteInstanceBaseUrl: targetEntity.type.baseUrl,
                        remoteEntityType: targetEntity.type.capabilityKey,
                        remoteEntityKey: targetEntity.data.key
                    });
                }
            });
        });

        //TODO ROTP-992 : Doesn't need to be serialized once applinks fixes up race condition
        var numErrors = 0;

        function createNext(xhr, status) {
            if (status !== "success") {
                numErrors++;
                // render the error message
                var errorMessage = xhr.statusText;
                try {
                    var data = JSON.parse(xhr.responseText);
                    if (data && data.message) {
                        errorMessage = data.message;
                    }
                } catch (err) {

                }
                AJS.messages.error(".li-linking-status", {
                    title: AJS.I18n.getText("project.create.error.occurred.creating.link"),
                    body: errorMessage
                });
                dialog.updateHeight();
            }
            if (linksToCreate.length > 0) {
                ATLAS_PROJECT_CREATE.createLink(linksToCreate.pop(), createNext);
            } else {
                if (numErrors > 0) {
                    projectCreationPage.find(".linking-status").html('<span class="aui-icon aui-icon-small aui-iconfont-error">' + AJS.I18n.getText('project.create.dialog.error') + '</span>');
                } else {
                    projectCreationPage.find(".linking-status").html('<span class="aui-icon aui-icon-small aui-iconfont-success">' + AJS.I18n.getText('project.create.dialog.success') + '</span>');
                }
                acknowledgeButton.prop("disabled", false);
                acknowledgeButton.attr('aria-disabled', 'false');
            }
        }

        createNext(null, "success");
    };

    var remoteRootsPromise;

    function bindRemoteRootsPromise(promise, getDialog, onCheckboxChange) {
        var dialog = getDialog();
        $.when(promise).then(
            // success handler
            function (types) {
                dialog.getCurPanel().body.find('.field-group.loading').remove();

                types.sort(sortCapabilities);
                if (types.length !== 0) {
                    var projectCreateForm = dialog.getCurPanel().body.find('form');
                    projectCreateForm.append(project.creation.remoteRootsCheckboxes({rootTypes: types}));
                    if (onCheckboxChange) {
                        projectCreateForm.find('input[type="checkbox"]').filter('.remote-root').change(onCheckboxChange);
                    }

                    dialog.updateHeight();
                }

                enableSubmitBtn(dialog, true);
            },
            // fail handler
            function () {
                dialog.getCurPanel().body.find('.field-group.loading').remove();
                enableSubmitBtn(dialog, true);
                dialog.updateHeight();
                // the provided promise only ever resolves. This shouldn't happen, but if something explodes it should
                // be enough to just revert back to default JIRA behaviour.
            }
        );
    }

    var panel;

    function setupProjectCreationIntegration(getDialog, onCheckboxChange) {
        var dialog = getDialog();
        //Store a ref to the panel for use in some promises
        panel = dialog.getCurPanel();
        // Attach some info and a spinner below Project Create name & key entry
        panel.body.find('form').append(project.creation.remoteRootsLoading({}));

        enableSubmitBtn(dialog, false);
        dialog.updateHeight();

        //Make sure the height is good again when the user hits back
        panel.page.element.find(".add-project-back-button").click(function() {
            dialog.updateHeight();
        });


        initRemoteRoots(bindRemoteRootsPromise, getDialog, onCheckboxChange);
    }

    function getSelectedTypes(types) {
        var selectedCheckboxes = _.filter(panel.body.find("input.remote-root.checkbox"), function (checkbox) {
            return checkbox.checked === true;
        });
        var selectedTypeIds = _.map(selectedCheckboxes,
            function (input) {
                return input.id;
            });
        return _.filter(types, function (type) {
            return _.contains(selectedTypeIds, 'capability_' + type.capabilityKey);
        });
    }

    var userMetaTag = AJS.$('meta[name="ajs-remote-user"]');
    // if we neither got a user tag, or it had no content then bail out.
    if (!userMetaTag || !userMetaTag[0] || !userMetaTag[0].content) {
        console.log("Project create didn't get a user META tag, or it had no content.  Bailing out");
        return;
    }

    // if the dark feature is disabled, return here.
    if (!AJS.DarkFeatures.isEnabled("rotp.project.create")) {
        return;
    }

    var postProjectCreationCallback = function postProjectCreationCallback(dialog, redirectFn, projectId, projectKey, projectName) {
        var callRedirectFn = function callRedirectFn(redirectFn, acknowledgeButton) {
            acknowledgeButton.prop("disabled", true);
            acknowledgeButton.attr('aria-disabled', 'true');
            acknowledgeButton.before('<span class="aui-icon aui-icon-wait project-creation-acknowledge-spinner">' + AJS.I18n.getText('project.create.dialog.loading') + '</span>');
            redirectFn();
        };

        $.when(remoteRootsPromise).then(
            function (types) {
                var selectedTypes = getSelectedTypes(types);
                sendAnalytics(selectedTypes);

                if (selectedTypes.length === 0) {
                    //Make sure we don't show empty next page which is the default of project templates
                    dialog.prevPage();
                    redirectFn();
                    return;
                }

                createProjectCreationResultPanel(dialog, callRedirectFn, redirectFn);

                var templateData = [];
                var createdThings = [];
                mapToPromise(selectedTypes, function (type) {
                    var statusId = "creation_status_" + type.capabilityKey.replace(".", "_") + "_" + type.instanceId;
                    templateData.push({
                        statusId: statusId,
                        label: type.label
                    });

                    return AJS.$.ajax(type.url + "/" + projectKey, {
                        type: "PUT",
                        data: JSON.stringify({
                            label: projectName
                        }),
                        xhrFields: {
                            withCredentials: true
                        },
                        success: function (data) {
                            createdThings = createdThings.concat(processCreatedRoots(data, type));
                            renderCreatedRoots(data, statusId);
                        },
                        error: function (xhr, textStatus, errorThrown) {
                            renderErrorDuringRootCreation(statusId, type, xhr, errorThrown);
                        },
                        contentType: "application/json",
                        dataType: "json"
                    }).promise();
                }).always(function () {
                    renderErrorHeaderInCaseOfErrors(dialog);
                    console.log("about to begin linking created objects");
                    ATLAS_PROJECT_CREATE.linkAllTheThings(dialog,
                                                            createdThings,
                                                            projectKey,
                                                            AJS.$(".post-project-created-page-content"),
                                                            AJS.$(".project-create-acknowledge-button"));
                });

                AJS.$(".post-project-created-page-content").append(project.creation.remoteRootsSuccess({rootTypes: templateData}));
            }
        );
    };


    var checkIfKeyExists = function checkIfKeyExists(projectKey) {
        var duplicateFound;
        $.when(remoteRootsPromise).then(
            function (types) {
                var selectedTypes = getSelectedTypes(types);
                _.each(selectedTypes, function (type) {
                    if (type.keys) {
                        for (var key in type.keys) {
                            if (type.keys.hasOwnProperty(key)) {
                                if (projectKey.toUpperCase() === key.toUpperCase()) {
                                    duplicateFound = type;
                                }
                            }
                        }
                    }
                });
            });
        var response = {errors: {}};
        if (duplicateFound) {
            response.errors.projectKey = AJS.I18n.getText("project.creation.with.that.key.already.exists", duplicateFound.label);
        }
        return response;
    };


    function getOrigin() {
        return window.location.origin ? window.location.origin : (window.location.protocol + '//' + window.location.host);
    }

    function getAppBaseUrl() {
        var baseUrl = getOrigin();
        return baseUrl + AJS.contextPath();
    }

    /**
     * Parse and return some components of a URL.
     * @param {string} url A URL, e.g. "http://google.com:80/a/b/c"
     * @returns {{host: string, protocol: string, port: string}}
     */
    function parseUrl(url) {
        var a = document.createElement('a');
        a.href = url;
        return {
            host: a.hostname,
            port: a.port,
            protocol: a.protocol.replace(':', '')
        };
    }

    /**
     * Determine if making a request from one URL to another would represent a security downgrade, and
     * as such be blocked by the browser.
     *
     * @param {string} origin The URL from which a request to *destination* is to be made.
     * @param {string} destination The destination URL.
     * @returns {boolean} true if origin uses https: and destination uses http:
     */
    function isSecurityDowngrade(origin, destination) {
        var aParts = parseUrl(origin);
        var bParts = parseUrl(destination);
        return aParts.protocol === "https" && bParts.protocol === "http";
    }

    function initRemoteRoots(fn, getDialog, onCheckboxChange) {
        AJS.$.ajax(getAppBaseUrl() + '/rest/capabilities/awareness', {
            type: "GET",

            /**
             * @param {{applications: object, links: {selfInstanceId: string} }} data
             */
            success: function parseAwarenessResponse(data) {
                // We need to be careful with what requests we make. Making a request from a HTTPS page to a HTTP
                // page will be blocked by the browser and will only fail after the timeout period has elapsed.
                var willTimeout = _.partial(isSecurityDowngrade, getOrigin());
                var capabilities = _
                    .chain(data.applications)
                    .map(function (details, url) {
                        return _.extend(details, {capabilitiesUrl: url});
                    })
                    .filter(function (details) {
                        return willTimeout(details.capabilitiesUrl) === false;
                    })
                    .value();

                //push an object in to gather any local capabilities
                capabilities.push({
                    id: data.links.selfInstanceId,
                    capabilitiesUrl: data.links.collection
                });

                remoteRootsPromise = ATLAS_PROJECT_CREATE.loadRemoteRoots(capabilities);
                selfInstanceId = data.links.selfInstanceId;
                if (typeof fn === 'function') {
                    fn(remoteRootsPromise, getDialog, onCheckboxChange);
                }
            },
            error: function (xhr, status, errorThrown) {
                // log & revert to vanilla JIRA behaviour.
                console.log("Project create error - error gathering roots from awareness capability");
                if (getDialog) {
                    $(getDialog().getCurPanel().page.element).find(".pt-submit-button").attr('aria-disabled', 'false');
                }
            }
        });
    }


    var selfInstanceId;
    var odFecruAwareness = null;

    // given a list<X> and a function fn : X -> promise returns a promise composed
    // of all the promises returned by applying fn to members of list
    function mapToPromise(list, fn) {
        var promises = _.map(list, fn);
        return promiseFromPromiseList(promises);
    }

    // given a list of promises, construct a new promise which fires done when all proivded promises have either been resolved or rejected.
    // NOTE: can not just be return $.when.apply(promises).promise() because that would reject when the first internal promise is rejected,
    // whereas we want the promise to fire after all are completed.
    // Again, NOTE: resolution of the returned promise will be empty. This should only be used when you want flow control,
    // data access should be by other means (or wrapped around one of these).
    function promiseFromPromiseList(promises) {
        var deferred = $.Deferred();
        var resolutionCount = 0;
        if (promises.length === 0) {
            deferred.resolve();
        } else {
            _.each(promises, function (promise) {
                promise.always(function () {
                    resolutionCount++;
                    if (resolutionCount === promises.length) {
                        deferred.resolve();
                    }
                });
            });
        }
        return deferred.promise();
    }

    function createProjectCreationResultPanel(dialog, callRedirectFn, redirectFn) {
        dialog.addPanel("title", "", "post-project-created-page-content");
        dialog.addHeader(AJS.I18n.getText("project.creation.remote.apps.success.header"));
        dialog.addButton(AJS.I18n.getText("project.creation.remote.apps.success.acknowledge.button"), function () {
            callRedirectFn(redirectFn, AJS.$(this));
        }, "project-create-acknowledge-button");

        AJS.$(".project-create-acknowledge-button").removeClass("button-panel-button")
            .addClass("aui-button aui-button-primary")
            .attr('aria-disabled', 'true')
            .prop('disabled', true);
    }

    function processCreatedRoots(data, type) {
        var createdThings = [];
        if (type.capabilityKey === "ondemand.svn-repository") {
            // TODO: Remove this special case when FeCru is removed from OnDemand
            // this is a hack to handle the fact that SVN repositories
            // are being created in JIRA.
            console.log("got back created SVN repository");
            createdThings.push({
                type: {
                    capabilityKey: "fecru.repository",
                    instanceId: odFecruAwareness.id,
                    baseUrl: odFecruAwareness.capabilitiesUrl
                },
                data: {
                    key: data.key
                }
            });
            createdThings.push({
                type: {
                    capabilityKey: "fecru.project",
                    instanceId: odFecruAwareness.id,
                    baseUrl: odFecruAwareness.capabilitiesUrl
                },
                data: {
                    key: "CR-" + data.key
                }
            });
        } else {
            console.log("got back created thing " + type.capabilityKey);
            var createdThing = {
                type: type,
                data: data
            };
            createdThings.push(createdThing);
        }

        return createdThings;
    }

    function renderCreatedRoots(data, statusId) {
        var statusBlock = AJS.$("." + statusId);
        statusBlock.empty(); //remove spinner
        statusBlock.append('<span class="aui-icon aui-icon-small aui-iconfont-success">' + AJS.I18n.getText('project.create.dialog.success') + '</span>');
        if (data.links.resource) {
            var link = AJS.$("<a target='_blank'></a>");
            link.text(data.label);
            link.attr("href",data.links.resource);
            link.attr("title",data.label);
            statusBlock.closest('li').append(link);
        }
    }

    function renderErrorDuringRootCreation(statusId, type, xhr, errorThrown) {
        var statusBlock = AJS.$("." + statusId);
        statusBlock.empty(); //remove spinner
        statusBlock.append('<span class="aui-icon aui-icon-small aui-iconfont-error">' + AJS.I18n.getText('project.create.dialog.error') + '</span>');
        var errorMessage = errorThrown;
        if (xhr && xhr.responseText) {
            try {
                var data = JSON.parse(xhr.responseText);
                if (data && data.message) {
                    errorMessage = data.message;
                }
            } catch (err) {
                // swallow syntax error if response is not valid JSON and display the response text as error
                errorMessage = xhr.responseText;
            }
        }

        AJS.messages.error(".li-" + statusId, {
            title: AJS.I18n.getText("project.create.error.occurred.creating.entity", type.label),
            body: errorMessage
        });
    }

    function renderErrorHeaderInCaseOfErrors(dialog) {
        // if we have any errors, add a helpful message
        var currentPanel = dialog.getCurrentPanel();
        if (currentPanel.body.find('.aui-message.error').size() !== 0) {
            AJS.messages.warning('.project-creation-success', {
                title: AJS.I18n.getText('project.create.dialog.someerrors.header'),
                body: '<p>' + AJS.I18n.getText('project.create.dialog.someerrors.body') + '</p>'
            });

            dialog.updateHeight();
        }
    }

    function sendAnalytics(selectedTypes) {
        var capabilityKeys = _.map(selectedTypes, function (type) { return type.capabilityKey;});
        var analyticsValue = (capabilityKeys.length == 0) ? "none" : capabilityKeys.sort().join('_');

        AJS.EventQueue.push({name: 'project.create.aggregateroots.selected', properties: {capabilitykeys: analyticsValue}});
    }

    function enableSubmitBtn(dialog, enabled) {
        $(dialog.getCurPanel().page.element).find(".pt-submit-button").attr('aria-disabled', !enabled);
    }

    function sortCapabilities(capabilityA, capabilityB) {
        return getCapabilityWeight(capabilityB.capabilityKey) - getCapabilityWeight(capabilityA.capabilityKey);
    }

    function getCapabilityWeight(capabilityKey) {
        return _.has(CAPABILITY_WEIGHT, capabilityKey) ? CAPABILITY_WEIGHT[capabilityKey] : 0;
    }



    JPT.AddProjectController.registerProjectKeyValidationCallback(checkIfKeyExists);

    var getJptDialog = function getJptDialog() {
        return JPT.DialogView.dialog || JPT.DialogView._dialog;
    };
    var onJptCheckboxChange = function onJptCheckboxChange() {
        if (JPT.AddProjectView.getKey().length >= 2) {
            JPT.AddProjectController._performKeyValidationChecks(JPT.AddProjectView.getKey());
        }
    };

    JPT.AddProjectView.addPostDrawCallback(function () {
        setupProjectCreationIntegration(getJptDialog, onJptCheckboxChange);
    });

    JPT.AddProjectController.registerPostProjectCreationCallback(function (dialog, returnUrl, projectId, projectKey, projectName) {
        var redirectFn = function() {
            window.location = AJS.contextPath() + returnUrl;
        };
        postProjectCreationCallback(dialog, redirectFn, projectId, projectKey, projectName);
    });

    // Embed project create in Greenhopper project create flow
    // (But only in flow creating a JIRA project at the same time)
    var registerGhCallbacks = function registerGhCallbacks() {
        var GH_PROJECT_CREATION_STEP = "projectCreation";
        GH.StartWizardView.registerWizardStepPreRenderCallback(function ghProjectCreateSetup(stepName) {
            if (stepName == GH_PROJECT_CREATION_STEP) {
                initRemoteRoots();

                GH.StartWizardView.registerWizardStepOnCreateCallbacks(function ghProjectCreageCallback(dialog, executeNextCallback, model) {
                    console.log("creating external entities");
                    dialog.addPage("post-project-created-page");
                    postProjectCreationCallback(dialog, executeNextCallback, null, model.project.key, model.project.name);
                });
            }
        });
        GH.StartWizardView.registerWizardStepPostRenderCallback(function renderGhProjectCheckboxes(stepName, dialog) {
            if (stepName == GH_PROJECT_CREATION_STEP) {
                setupProjectCreationIntegration(function getGhDialog() {
                    return dialog;
                });
                dialog.updateHeight();
            }
        });
        GH.StartWizardView.registerWizardStepOnValidateCallback(function validateProjectKey(stepName, dialog) {
            if (stepName == GH_PROJECT_CREATION_STEP) {
                var $keyInput = dialog.getCurPanel().body.find("#ghx-wizard-project-projectkey");
                var keyExistsResponse = checkIfKeyExists($keyInput.val());
                if (keyExistsResponse.errors.projectKey) {
                    var $errorElement = AJS.$("<div class='error project-creation-error'></div>");
                    var parent = $keyInput.parent();
                    parent.find(".project-creation-error").remove();
                    parent.append($errorElement);
                    $errorElement.text(keyExistsResponse.errors.projectKey);
                    $errorElement.show();
                    return false;
                }
            }
            return true;
        });
    };

    $(function() {

        // Embed project create in JIRA project templates dialog
        // on clicking the project create link, we want to start gathering our capabilities
        AJS.$('.add-project-trigger').live('click', initRemoteRoots);

        // check if Greenhopper is available and that it is a version which has support for the required
        // callbacks.  If so, register greenhopper callbacks
        if (typeof GH !== 'undefined') {
            if (GH.StartWizardView && GH.StartWizardView.registerWizardStepPreRenderCallback) {
                // GH has support for the required callbacks....
                registerGhCallbacks();
            }
        }
    });

    // Embed project create in JIRA project templates dialog
    // on clicking the project create link, we want to start gathering our capabilities
    $(function () {
        AJS.$('.add-project-trigger').live('click', initRemoteRoots);
    });


})(jQuery);
