define("jira/postsetup/announcements-view-lib",["jira/util/logger","jira/ajs/ajax/smart-ajax","wrm/context-path","jira/jquery/deferred","jquery","underscore","aui/inline-dialog"],function(logger,SmartAjax,wrmContextPath,Deferred,$,_,InlineDialog){var EVENT_KEY="post.setup.announcement";var closeElementsClass="post-setup-discovery-close-js";var actionElementClass="post-setup-action-js";function soyTemplateAnnouncementBody(template){return function($popup,$content){var text=template({popupId:$popup[0].id,closeElementClass:closeElementsClass,actionElementClass:actionElementClass});$popup.on("click","."+closeElementsClass,function(event){event.preventDefault();$popup.hide()});var container=JIRA.Templates.PostSetupLib.discoveryContentContainer({content:soydata.VERY_UNSAFE.ordainSanitizedHtml(text)});$content.html(container)}}function ifOnPage(path,elementPromiseFn){return function(){if(location.pathname.indexOf(path)>=0){return elementPromiseFn()}else{var rejected=Deferred().reject();return rejected.promise()}}}function findElement(elementSelector){return function(){var $element=$(elementSelector);var deferred=Deferred();if($element.length>0){deferred.resolve($element)}else{deferred.reject()}return deferred.promise()}}function inViewPort(elementPromiseFn){return function(){var promise=elementPromiseFn();var awaitPromise=promise.pipe(function($element){var deferred=Deferred();function elementInViewResolved(){if($element.isInView({margin:10})){deferred.resolve($element);return true}else{return false}}if(!elementInViewResolved()){$(window).scroll(_.throttle(function(event){if(elementInViewResolved()){$(this).unbind(event)}},100))}return deferred.promise()});return awaitPromise}}function holdOnTillFlagsAreGone(elementPromiseFn){return function(){var promise=elementPromiseFn();var awaitPromise=promise.pipe(function($element){var deferred=Deferred();setTimeout(function(){function noFlagsResolved(){var visibleFlags=$(".aui-flag[aria-hidden=false]");if(visibleFlags.length===0){deferred.resolve($element);return true}else{return false}}if(!noFlagsResolved()){$(document).on("aui-flag-close",function(event){if(noFlagsResolved()){$(this).unbind(event)}})}},0);return deferred.promise()});return awaitPromise}}function holdOnTillDialogsAreGone(elementPromiseFn){return function(){var promise=elementPromiseFn();var awaitPromise=promise.pipe(function($element){var deferred=Deferred();function noDialogsResolved(){var visibleDialogs=$(".aui-inline-dialog");var noDialogs=!visibleDialogs.is(":visible");if(noDialogs){deferred.resolve($element);return true}else{return false}}var timeoutId=setInterval(function(){if(noDialogsResolved()){clearTimeout(timeoutId)}},750);return deferred.promise()});return awaitPromise}}var GRAVITY_BELOW="n";var GRAVITY_LEFT="w";var Announcement=function(announcementId,template,anchorPromiseFunction,dialogAnchorGravity,weight,blockOther){return{getId:function(){return announcementId},getAnchor:anchorPromiseFunction,buildAnnouncementBody:template,anchorGravity:dialogAnchorGravity||GRAVITY_BELOW,weight:weight||0,blockOther:blockOther}};var AnnouncementsController=function(viewsDefinitions,readyAnnouncements){var emptyDefinition={weight:0};this.viewsDefinitions=viewsDefinitions;this.announcements=_.sortBy(readyAnnouncements,function(it){return(viewsDefinitions[it]||emptyDefinition).weight})};AnnouncementsController.prototype.createFlags=function(){_.find(this.announcements,function(announcementId){var announcement=this.viewsDefinitions[announcementId];if(typeof announcement!=="undefined"){var annoucementPresented=this.announce(announcement);return annoucementPresented}else{return false}},this)};AnnouncementsController.prototype.announce=function(announcement){var annoucementPresentedPromise=this.addFlag(announcement);annoucementPresentedPromise.pipe(_.bind(function(){this.dismiss([announcement.getId()])},this));return annoucementPresentedPromise.state()!=="rejected"&&(announcement.blockOther||annoucementPresentedPromise.state()==="resolved")};AnnouncementsController.prototype.dismiss=function(announcements){SmartAjax.makeRequest({url:wrmContextPath()+"/rest/onboarding/1/postsetup_announcement/announced",async:true,contentType:"application/json",type:"POST",dataType:"json",data:JSON.stringify(announcements)}).done(function(){logger.log("Dismissed: "+announcements)}).fail(function(){logger.log("Dismissal failed: "+announcements)})};function pushAnalyticsEvent(eventName,properties){if(AJS.trigger){var analyticsEventName=EVENT_KEY+"."+eventName;properties=properties||{};AJS.trigger("analyticsEvent",{name:analyticsEventName,data:properties})}}function handleAnalyticsEventsOnAnnouncement(announcement,popup){pushAnalyticsEvent(announcement.getId()+".show");popup.on("click","."+closeElementsClass,function(){pushAnalyticsEvent(announcement.getId()+".dismiss")});popup.on("click","."+actionElementClass,function(){pushAnalyticsEvent(announcement.getId()+".action")})}AnnouncementsController.prototype.addFlag=function(announcement){var activityIdCssCompatible=announcement.getId().replace(/[. #>+]/g,"-");var id="post-setup-announcement-"+activityIdCssCompatible;var anchorPromise=announcement.getAnchor();var defer=anchorPromise.pipe(function(anchor){var popup=InlineDialog(anchor,id,function(content,trigger,showPopup){announcement.buildAnnouncementBody(popup,content);showPopup()},{noBind:true,hideDelay:null,persistent:true,width:350,gravity:announcement.anchorGravity});popup.show(null,anchor);popup.addClass("aui-help");setTimeout(function(){popup.scrollIntoView();anchor.scrollIntoView()},0);handleAnalyticsEventsOnAnnouncement(announcement,popup);return true});return defer.promise()};var exportSymbols={ifOnPage:ifOnPage,findElement:findElement,inViewPort:inViewPort,holdOnTillFlagsAreGone:holdOnTillFlagsAreGone,holdOnTillDialogsAreGone:holdOnTillDialogsAreGone,soyTemplateAnnouncementBody:soyTemplateAnnouncementBody,closeElementClass:closeElementsClass,actionElementClass:actionElementClass,GRAVITY_BELOW:GRAVITY_BELOW,GRAVITY_LEFT:GRAVITY_LEFT,AnnouncementsController:AnnouncementsController,Announcement:Announcement};return exportSymbols});