/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.onboarding;

import com.atlassian.fugue.Option;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementService;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementStatus;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="postsetup_announcement")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PostSetupActivitiesResource {
    private final PostSetupAnnouncementService announcements;
    private final JiraAuthenticationContext authContext;

    @Inject
    public PostSetupActivitiesResource(PostSetupAnnouncementService announcements, @ComponentImport JiraAuthenticationContext authContext) {
        this.announcements = announcements;
        this.authContext = authContext;
    }

    @GET
    @Path(value="ready")
    public Response getReadyAnnouncements() {
        Option applicationUser = Option.option((Object)this.authContext.getUser());
        List<PostSetupAnnouncementStatus> readyAnnouncemends = this.announcements.getReadyAnnouncements((Option<ApplicationUser>)applicationUser);
        Iterable readyAnnouncementsBeans = Iterables.transform(readyAnnouncemends, (Function)PostSetupActivityStatusBean.FROM_ANNOUNCEMENT_STATUS);
        return Response.ok((Object)ImmutableList.copyOf((Iterable)readyAnnouncementsBeans)).build();
    }

    @GET
    @Path(value="reset")
    @VisibleForTesting
    public Response reset() {
        Option applicationUser = Option.option((Object)this.authContext.getUser());
        this.announcements.reset((Option<ApplicationUser>)applicationUser);
        return Response.ok().build();
    }

    @GET
    @Path(value="recalculate")
    public Response recalculate() {
        Option applicationUser = Option.option((Object)this.authContext.getUser());
        this.announcements.recalculateStatuses((Option<ApplicationUser>)applicationUser);
        return Response.ok().build();
    }

    @POST
    @Path(value="announced")
    public Response acitiviesAnnounced(List<String> announcedActivities) {
        Option applicationUser = Option.option((Object)this.authContext.getUser());
        this.announcements.activitiesAnnounced((Option<ApplicationUser>)applicationUser, announcedActivities);
        return Response.ok().build();
    }

    @XmlRootElement(name="postSetupActivityStatus")
    public static class PostSetupActivityStatusBean {
        @XmlElement
        private String activityId;
        @XmlElement
        private PostSetupAnnouncementStatus.Status status;
        private static Function<PostSetupAnnouncementStatus, PostSetupActivityStatusBean> FROM_ANNOUNCEMENT_STATUS = new Function<PostSetupAnnouncementStatus, PostSetupActivityStatusBean>(){

            public PostSetupActivityStatusBean apply(PostSetupAnnouncementStatus input) {
                return new PostSetupActivityStatusBean(input.getActivityId(), input.getActivityStatus());
            }
        };

        PostSetupActivityStatusBean(String activityId, PostSetupAnnouncementStatus.Status status) {
            this.activityId = activityId;
            this.status = status;
        }

        public String getActivityId() {
            return this.activityId;
        }

        public PostSetupAnnouncementStatus.Status getStatus() {
            return this.status;
        }
    }
}

