/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.postsetup.checks;

import com.atlassian.core.util.Clock;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.springframework.stereotype.Component;

@Component
public class EvaluationLicenseAgeCheck {
    private final JiraLicenseManager licenseManager;
    private final Clock clock;

    @Inject
    public EvaluationLicenseAgeCheck(@ComponentImport JiraLicenseManager licenseManager, @ComponentImport Clock clock) {
        this.licenseManager = licenseManager;
        this.clock = clock;
    }

    @Nonnull
    public LicenseChecker getCurrentLicenseCheck() {
        return new LicenseChecker(this.licenseManager.getLicenses(), this.clock);
    }

    public class LicenseChecker {
        private final Iterable<LicenseDetails> licenses;
        private final Clock clock;

        public LicenseChecker(Iterable<LicenseDetails> allLicenses, Clock clock) {
            this.licenses = allLicenses;
            this.clock = clock;
        }

        public boolean isEvaluation() {
            return this.isEvaluation(this.licenses);
        }

        public boolean isEvaluationLicenseOld(final Period period) {
            ImmutableList allLicenses = ImmutableList.copyOf(this.licenses);
            boolean evaluation = this.isEvaluation((Iterable<LicenseDetails>)allLicenses);
            Option evaluationLicense = evaluation ? com.atlassian.fugue.Iterables.first((Iterable)allLicenses) : Option.none();
            Boolean isEvaluatingEnough = (Boolean)evaluationLicense.fold(Suppliers.alwaysFalse(), (Function)new Function<LicenseDetails, Boolean>(){

                public Boolean apply(LicenseDetails input) {
                    return LicenseChecker.this.isLicenseThisOld(input, period);
                }
            });
            return isEvaluatingEnough;
        }

        private boolean isEvaluation(Iterable<LicenseDetails> allLicenses) {
            boolean allEvaluationLicenses = Iterables.all(allLicenses, (Predicate)new Predicate<LicenseDetails>(){

                public boolean apply(LicenseDetails input) {
                    return input.isEvaluation();
                }
            });
            return allEvaluationLicenses;
        }

        private Boolean isLicenseThisOld(LicenseDetails input, Period period) {
            Date licensePurchaseDate = input.getJiraLicense().getPurchaseDate();
            return new DateTime((Object)licensePurchaseDate).withPeriodAdded((ReadablePeriod)period, 1).isBefore((ReadableInstant)new DateTime((Object)this.clock.getCurrentDate()));
        }
    }
}

