/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.postsetup;

import com.atlassian.fugue.Option;
import com.atlassian.jira.onboarding.postsetup.AnnouncementAccessPolicy;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncement;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementProvider;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementService;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementStatus;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementStore;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@ExportAsService(value={PostSetupAnnouncementService.class})
@Component
public class PostSetupAnnouncements
implements PostSetupAnnouncementService {
    final PostSetupAnnouncementStore postSetupAnnouncementStore;
    final PostSetupAnnouncementProvider postSetupAnnouncementProvider;
    final AnnouncementAccessPolicy announcementAccessPolicy;

    @Inject
    public PostSetupAnnouncements(PostSetupAnnouncementStore postSetupAnnouncementStore, PostSetupAnnouncementProvider postSetupAnnouncementProvider, AnnouncementAccessPolicy announcementAccessPolicy) {
        this.postSetupAnnouncementStore = postSetupAnnouncementStore;
        this.postSetupAnnouncementProvider = postSetupAnnouncementProvider;
        this.announcementAccessPolicy = announcementAccessPolicy;
    }

    @Override
    public void recalculateStatuses(Option<ApplicationUser> user) {
        if (!this.announcementAccessPolicy.canUpdate(user)) {
            throw new SecurityException("User can't recalculate statuses");
        }
        final Set<String> announcedActivities = this.getDoneActivityIds();
        List<PostSetupAnnouncement> registeredActivities = this.postSetupAnnouncementProvider.getAnouncements();
        Iterable notAnnouncedActivities = Iterables.filter(registeredActivities, (Predicate)new Predicate<PostSetupAnnouncement>(){

            public boolean apply(PostSetupAnnouncement input) {
                boolean wasActivityAnnounced = announcedActivities.contains(input.getAnouncementId());
                return !wasActivityAnnounced;
            }
        });
        Iterable currentStatuses = Iterables.transform((Iterable)notAnnouncedActivities, (Function)new Function<PostSetupAnnouncement, PostSetupAnnouncementStatus>(){

            public PostSetupAnnouncementStatus apply(PostSetupAnnouncement input) {
                PostSetupAnnouncementStatus.Status status = input.computeStatus();
                return new PostSetupAnnouncementStatus(input.getAnouncementId(), status);
            }
        });
        this.postSetupAnnouncementStore.updateStatuses(currentStatuses);
    }

    @Override
    public void activitiesAnnounced(Option<ApplicationUser> user, List<String> activityIds) {
        if (!this.announcementAccessPolicy.canUpdate(user)) {
            throw new SecurityException("User can't mark activities as announced");
        }
        Set<String> allActivitiesIds = this.getAllActivitiesIds();
        ImmutableSet notRegisteredActivities = Sets.difference((Set)ImmutableSet.copyOf(activityIds), allActivitiesIds).immutableCopy();
        if (!notRegisteredActivities.isEmpty()) {
            throw new NoSuchElementException(Iterables.toString((Iterable)notRegisteredActivities));
        }
        Iterable currentStatuses = Iterables.transform(activityIds, (Function)new Function<String, PostSetupAnnouncementStatus>(){

            public PostSetupAnnouncementStatus apply(String activityId) {
                return new PostSetupAnnouncementStatus(activityId, PostSetupAnnouncementStatus.Status.ANNOUNCED);
            }
        });
        this.postSetupAnnouncementStore.updateStatuses(currentStatuses);
    }

    @Override
    public List<PostSetupAnnouncementStatus> getReadyAnnouncements(final Option<ApplicationUser> user) {
        if (!this.announcementAccessPolicy.canRead(user)) {
            return Collections.emptyList();
        }
        List<PostSetupAnnouncementStatus> allStatuses = this.postSetupAnnouncementStore.getAllStatuses();
        ArrayList readyAnouncements = Lists.newArrayList((Iterable)Iterables.filter(allStatuses, (Predicate)new Predicate<PostSetupAnnouncementStatus>(){

            public boolean apply(PostSetupAnnouncementStatus announcementStatus) {
                return PostSetupAnnouncements.this.isReadyForAnnouncement((Option<ApplicationUser>)user, announcementStatus);
            }
        }));
        return readyAnouncements;
    }

    @Override
    public boolean hasAnnouncements(final Option<ApplicationUser> user) {
        if (!this.announcementAccessPolicy.canRead(user)) {
            return false;
        }
        List<PostSetupAnnouncementStatus> allStatuses = this.postSetupAnnouncementStore.getAllStatuses();
        boolean isAnyAnnouncementReady = Iterables.any(allStatuses, (Predicate)new Predicate<PostSetupAnnouncementStatus>(){

            public boolean apply(PostSetupAnnouncementStatus announcementStatus) {
                return PostSetupAnnouncements.this.isReadyForAnnouncement((Option<ApplicationUser>)user, announcementStatus);
            }
        });
        return isAnyAnnouncementReady;
    }

    @Override
    public void reset(Option<ApplicationUser> user) {
        if (!this.announcementAccessPolicy.canUpdate(user)) {
            throw new SecurityException("User cannot reset");
        }
        Iterable initialStatuses = Iterables.transform(this.getAllActivitiesIds(), (Function)new Function<String, PostSetupAnnouncementStatus>(){

            public PostSetupAnnouncementStatus apply(String activtyId) {
                return new PostSetupAnnouncementStatus(activtyId, PostSetupAnnouncementStatus.Status.AWAITS);
            }
        });
        this.postSetupAnnouncementStore.updateStatuses(initialStatuses);
    }

    private Set<String> getAllActivitiesIds() {
        List<PostSetupAnnouncement> allStatuses = this.postSetupAnnouncementProvider.getAnouncements();
        return Sets.newHashSet((Iterable)Iterables.transform(allStatuses, (Function)new Function<PostSetupAnnouncement, String>(){

            public String apply(PostSetupAnnouncement input) {
                return input.getAnouncementId();
            }
        }));
    }

    private Set<String> getDoneActivityIds() {
        List<PostSetupAnnouncementStatus> allStatuses = this.postSetupAnnouncementStore.getAllStatuses();
        Iterable announcedStatuses = Iterables.filter(allStatuses, (Predicate)new Predicate<PostSetupAnnouncementStatus>(){

            public boolean apply(PostSetupAnnouncementStatus input) {
                return PostSetupAnnouncements.this.isStatusDone(input.getActivityStatus());
            }
        });
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)announcedStatuses, (Function)new Function<PostSetupAnnouncementStatus, String>(){

            public String apply(PostSetupAnnouncementStatus input) {
                return input.getActivityId();
            }
        }));
    }

    private boolean isStatusDone(PostSetupAnnouncementStatus.Status activityStatus) {
        return activityStatus == PostSetupAnnouncementStatus.Status.ANNOUNCED || activityStatus == PostSetupAnnouncementStatus.Status.FULLFILLED;
    }

    private boolean isReadyForAnnouncement(Option<ApplicationUser> user, PostSetupAnnouncementStatus input) {
        return input.getActivityStatus() == PostSetupAnnouncementStatus.Status.ANNOUNCE;
    }
}

