/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.postsetup;

import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncement;
import com.atlassian.jira.onboarding.postsetup.checks.AnnounceWhenInstantPathTakenCheck;
import com.atlassian.jira.onboarding.postsetup.checks.DatabaseSetUpChecker;
import com.atlassian.jira.onboarding.postsetup.checks.OutgoingMailSetUpChecker;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class PostSetupAnnouncementProvider {
    public static final String DATABASE_SETUP = "database.setup";
    public static final String APP_PROPERTIES_SETUP = "app.properties.setup";
    public static final String MAIL_PROPERTIES_SETUP = "mail.properties.setup";
    public static final String CU_MAIL_PROPERTIES_SETUP = "create.user.mail.properties.setup";
    private final ImmutableList<PostSetupAnnouncement> annoucements;

    @Inject
    public PostSetupAnnouncementProvider(DatabaseSetUpChecker databaseSetUpChecker, AnnounceWhenInstantPathTakenCheck announceWhenInstantPathTakenCheck, OutgoingMailSetUpChecker mailSetUpChecker) {
        this.annoucements = ImmutableList.of((Object)new PostSetupAnnouncement(DATABASE_SETUP, databaseSetUpChecker), (Object)new PostSetupAnnouncement(APP_PROPERTIES_SETUP, announceWhenInstantPathTakenCheck), (Object)new PostSetupAnnouncement(MAIL_PROPERTIES_SETUP, mailSetUpChecker), (Object)new PostSetupAnnouncement(CU_MAIL_PROPERTIES_SETUP, mailSetUpChecker));
    }

    @Nonnull
    public List<PostSetupAnnouncement> getAnouncements() {
        return this.annoucements;
    }
}

