/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.postsetup;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.jira.onboarding.postsetup.AnnouncementAccessPolicy;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class AdminOnlyAccessPolicy
implements AnnouncementAccessPolicy {
    private final GlobalPermissionManager permissionManager;

    @Inject
    public AdminOnlyAccessPolicy(@ComponentImport GlobalPermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean canRead(Option<ApplicationUser> userOption) {
        return this.isAdmin(userOption);
    }

    @Override
    public boolean canUpdate(Option<ApplicationUser> userOption) {
        return this.isAdmin(userOption);
    }

    private Boolean isAdmin(Option<ApplicationUser> userOption) {
        return (Boolean)userOption.fold(Suppliers.alwaysFalse(), (Function)new Function<ApplicationUser, Boolean>(){

            public Boolean apply(ApplicationUser user) {
                boolean isAdmin = AdminOnlyAccessPolicy.this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
                return isAdmin;
            }
        });
    }
}

