/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.passwordpolicy.config;

import com.atlassian.jira.plugins.passwordpolicy.config.PasswordPolicyConfiguration;
import com.atlassian.jira.plugins.passwordpolicy.config.SimilarityCheck;

public enum PasswordPolicyMode {
    DISABLED,
    BASIC{

        @Override
        public PasswordPolicyConfiguration applyTo(PasswordPolicyConfiguration config) {
            config.setMinimumLength(8);
            config.setMaximumLength(255);
            config.setMinimumLowercase(0);
            config.setMinimumUppercase(0);
            config.setMinimumDigits(0);
            config.setMinimumSpecial(0);
            config.setMinimumDistinctCharacterClasses(2);
            config.setSimilarityToOldPassword(SimilarityCheck.LENIENT);
            config.setSimilarityToUserInfo(SimilarityCheck.LENIENT);
            config.setEnablePassphraseExemption(false);
            return super.applyTo(config);
        }
    }
    ,
    SECURE{

        @Override
        public PasswordPolicyConfiguration applyTo(PasswordPolicyConfiguration config) {
            config.setMinimumLength(10);
            config.setMaximumLength(255);
            config.setMinimumLowercase(0);
            config.setMinimumUppercase(0);
            config.setMinimumDigits(0);
            config.setMinimumSpecial(1);
            config.setMinimumDistinctCharacterClasses(3);
            config.setSimilarityToOldPassword(SimilarityCheck.STRICT);
            config.setSimilarityToUserInfo(SimilarityCheck.STRICT);
            config.setEnablePassphraseExemption(false);
            return super.applyTo(config);
        }
    }
    ,
    CUSTOM;


    public static PasswordPolicyMode from(int setting) {
        PasswordPolicyMode[] values = PasswordPolicyMode.values();
        if (setting >= 0 && setting < values.length) {
            return values[setting];
        }
        return DISABLED;
    }

    public boolean isDisabled() {
        return this == DISABLED;
    }

    public boolean isCustom() {
        return this == CUSTOM;
    }

    public PasswordPolicyConfiguration applyTo(PasswordPolicyConfiguration config) {
        config.setPasswordPolicyMode(this);
        return config;
    }
}

