/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.passwordpolicy;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.plugin.user.PasswordPolicy;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.plugins.passwordpolicy.Message;
import com.atlassian.jira.plugins.passwordpolicy.analysis.CharacterClassAnalysis;
import com.atlassian.jira.plugins.passwordpolicy.analysis.CharacterFrequencyAnalysis;
import com.atlassian.jira.plugins.passwordpolicy.config.PasswordPolicyConfiguration;
import com.atlassian.jira.plugins.passwordpolicy.config.PasswordPolicyConfigurationLoader;
import com.atlassian.jira.plugins.passwordpolicy.config.SimilarityCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimplePasswordPolicy
implements PasswordPolicy {
    final I18nResolver i18n;
    final PasswordPolicyConfigurationLoader passwordPolicyConfigurationLoader;

    public SimplePasswordPolicy(I18nResolver i18n, PasswordPolicyConfigurationLoader passwordPolicyConfigurationLoader) {
        this.i18n = i18n;
        this.passwordPolicyConfigurationLoader = passwordPolicyConfigurationLoader;
    }

    public Collection<WebErrorMessage> validatePolicy(@Nonnull ApplicationUser user, @Nullable String oldPassword, @Nonnull String newPassword) {
        PasswordPolicyConfiguration config = this.getPasswordConfiguration();
        if (config.getPasswordPolicyMode().isDisabled()) {
            return ImmutableList.of();
        }
        return new ValidationContext(user, oldPassword, newPassword, config).validatePolicy();
    }

    public List<String> getPolicyDescription(boolean hasOldPassword) {
        PasswordPolicyConfiguration config = this.getPasswordConfiguration();
        if (config.getPasswordPolicyMode().isDisabled()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder advice = ImmutableList.builder();
        if (config.getMinimumLength() > 1) {
            advice.add((Object)Message.MINIMUM_LENGTH.snippet(this.i18n, config.getMinimumLength()));
        }
        advice.add((Object)Message.MAXIMUM_LENGTH.snippet(this.i18n, config.getMaximumLength()));
        if (config.getMinimumDistinctCharacterClasses() > 0) {
            advice.add((Object)Message.MINIMUM_CLASSES.snippet(this.i18n, config.getMinimumDistinctCharacterClasses()));
        }
        if (config.getMinimumUppercase() > 0) {
            advice.add((Object)Message.MINIMUM_UPPER.snippet(this.i18n, config.getMinimumUppercase()));
        }
        if (config.getMinimumLowercase() > 0) {
            advice.add((Object)Message.MINIMUM_LOWER.snippet(this.i18n, config.getMinimumLowercase()));
        }
        if (config.getMinimumDigits() > 0) {
            advice.add((Object)Message.MINIMUM_DIGITS.snippet(this.i18n, config.getMinimumDigits()));
        }
        if (config.getMinimumSpecial() > 0) {
            advice.add((Object)Message.MINIMUM_SPECIAL.snippet(this.i18n, config.getMinimumSpecial()));
        }
        if (!config.getSimilarityToOldPassword().isDisabled() && hasOldPassword) {
            advice.add((Object)Message.SIMILAR_TO_OLD_PASSWORD.snippet(this.i18n));
        }
        if (!config.getSimilarityToUserInfo().isDisabled()) {
            advice.add((Object)Message.SIMILAR_TO_USER_INFO.snippet(this.i18n));
        }
        return advice.build();
    }

    @VisibleForTesting
    protected PasswordPolicyConfiguration getPasswordConfiguration() {
        return this.passwordPolicyConfigurationLoader.load();
    }

    static boolean isPassphrase(String input) {
        if (input.length() < 16) {
            return false;
        }
        int pos = input.indexOf(32);
        if (pos < 0) {
            return false;
        }
        ++pos;
        while (pos < input.length()) {
            if (input.charAt(pos) != ' ') {
                return input.indexOf(32, pos) >= 0;
            }
            ++pos;
        }
        return false;
    }

    static String clean(String input) {
        return IdentifierUtils.toLowerCase((String)input).replace(' ', '_');
    }

    static String reverse(String input) {
        return new StringBuilder(input).reverse().toString();
    }

    static String rotate(String input) {
        int len = input.length();
        return new StringBuilder(len).append(input, 1, len).append(input.charAt(0)).toString();
    }

    class ValidationContext {
        final ApplicationUser user;
        final String oldPassword;
        final String newPassword;
        final PasswordPolicyConfiguration config;
        final ImmutableList.Builder<WebErrorMessage> errors;
        final CharacterClassAnalysis counts;

        ValidationContext(ApplicationUser user, String oldPassword, String newPassword, PasswordPolicyConfiguration config) {
            this.user = user;
            this.oldPassword = oldPassword;
            this.newPassword = newPassword;
            this.config = config;
            this.counts = CharacterClassAnalysis.of(newPassword);
            this.errors = ImmutableList.builder();
        }

        ImmutableList<WebErrorMessage> validatePolicy() {
            this.validateLengthAndTrim();
            this.validateCharacterTypes();
            this.validateSimilarity();
            return this.errors.build();
        }

        private void validateLengthAndTrim() {
            int minimumLength;
            int len = this.newPassword.length();
            if (len < (minimumLength = Math.max(1, this.config.getMinimumLength()))) {
                this.errors.add((Object)Message.MINIMUM_LENGTH.error(SimplePasswordPolicy.this.i18n, minimumLength));
                return;
            }
            int maximumLength = this.config.getMaximumLength();
            if (maximumLength > 0 && len > maximumLength) {
                this.errors.add((Object)Message.MAXIMUM_LENGTH.error(SimplePasswordPolicy.this.i18n, maximumLength));
            }
            if (this.newPassword.charAt(0) == ' ' || this.newPassword.charAt(len - 1) == ' ') {
                this.errors.add((Object)Message.LEADING_OR_TRAILING_SPACES.error(SimplePasswordPolicy.this.i18n));
            }
        }

        private void validateCharacterTypes() {
            if (this.counts.getInvalidCount() > 0 || this.counts.getControlCount() > 0) {
                this.errors.add((Object)Message.INVALID_CHARS.error(SimplePasswordPolicy.this.i18n));
            }
            if (this.config.getEnablePassphraseExemption() && SimplePasswordPolicy.isPassphrase(this.newPassword)) {
                return;
            }
            this.validateMinimum(this.config.getMinimumLowercase(), this.counts.getLowercaseLetterCount(), Message.MINIMUM_LOWER);
            this.validateMinimum(this.config.getMinimumUppercase(), this.counts.getUppercaseLetterCount(), Message.MINIMUM_UPPER);
            this.validateMinimum(this.config.getMinimumDigits(), this.counts.getDigitCount(), Message.MINIMUM_DIGITS);
            this.validateMinimum(this.config.getMinimumSpecial(), this.counts.getSpecialCount(), Message.MINIMUM_SPECIAL);
            this.validateMinimum(this.config.getMinimumDistinctCharacterClasses(), this.counts.getCharacterClassCount(), Message.MINIMUM_CLASSES);
        }

        private void validateSimilarity() {
            this.validateSimilarity(this.config.getSimilarityToOldPassword(), this.oldPassword, Message.SIMILAR_TO_OLD_PASSWORD);
            this.validateSimilarity(this.config.getSimilarityToUserInfo(), this.user, Message.SIMILAR_TO_USER_INFO);
        }

        private boolean validateSimilarity(SimilarityCheck setting, ApplicationUser user, Message message) {
            if (user == null) {
                return false;
            }
            return this.validateSimilarity(setting, user.getName(), message) || this.validateSimilarity(setting, user.getDisplayName(), message) || this.validateSimilarity(setting, user.getEmailAddress(), message);
        }

        private boolean validateSimilarity(SimilarityCheck setting, String template, Message message) {
            String cleanPassword;
            if (setting.isDisabled() || template == null || template.length() == 0) {
                return false;
            }
            String cleanTemplate = SimplePasswordPolicy.clean(template);
            if (this.hasMatchingRotatedSubstring(cleanTemplate, cleanPassword = SimplePasswordPolicy.clean(this.newPassword))) {
                this.errors.add((Object)message.error(SimplePasswordPolicy.this.i18n));
                return true;
            }
            if (setting.isFrequencyAnalysisEnabled() && CharacterFrequencyAnalysis.of(cleanTemplate).isSimilarTo(CharacterFrequencyAnalysis.of(cleanPassword))) {
                this.errors.add((Object)message.error(SimplePasswordPolicy.this.i18n));
                return true;
            }
            return false;
        }

        private boolean hasMatchingRotatedSubstring(String cleanTemplate, String cleanPassword) {
            String reversedPassword = SimplePasswordPolicy.reverse(cleanPassword);
            String s = cleanTemplate;
            do {
                if (!this.hasMatchingSubstring(s, cleanPassword, reversedPassword)) continue;
                return true;
            } while (!cleanTemplate.equals(s = SimplePasswordPolicy.rotate(s)));
            return false;
        }

        private boolean hasMatchingSubstring(String cleanTemplate, String cleanPassword, String reversedPassword) {
            return cleanTemplate.contains(cleanPassword) || cleanPassword.contains(cleanTemplate) || cleanTemplate.contains(reversedPassword) || reversedPassword.contains(cleanTemplate);
        }

        private void validateMinimum(int requestedMinimum, int actualValue, Message message) {
            if (requestedMinimum > 0 && actualValue < requestedMinimum) {
                this.errors.add((Object)message.error(SimplePasswordPolicy.this.i18n, requestedMinimum));
            }
        }
    }
}

