define("jira/onboarding/next-step-sequence-component",["jira/util/formatter","wrm/context-path","jira/onboarding/next-step-sequence-view","jira/util/browser","bluebird/Promise"],function(formatter,wrmContextPath,NextStepSequenceView,Browser,Promise){var NextStepSequenceComponent=function(options){options=options||{};this._validateOptions(options);this.canBrowseProjects=options.canBrowseProjects;this.canCreateIssues=options.canCreateIssues;this.canSearchIssues=options.canSearchIssues;this.steps=this._generateSteps()};NextStepSequenceComponent.prototype._validateOptions=function(options){if(typeof options.canBrowseProjects==="undefined"){throw new Error("Should have defined a permission to browse projects")}if(typeof options.canCreateIssues==="undefined"){throw new Error("Should have defined a permission to create issues")}if(typeof options.canSearchIssues==="undefined"){throw new Error("Should have defined a permission to search issues")}};NextStepSequenceComponent.prototype.init=function(container,analytics){var instance=this;return new Promise(function(resolve,reject){if(instance.steps.length===0){reject(NextStepSequenceComponent.REJECTION_TYPES.NO_PERMISSIONS)}else{resolve();var nextStepSequenceView=new NextStepSequenceView({el:container,steps:instance.steps});nextStepSequenceView.on("stepSelected",function(step){analytics.pushEvent(step.key);Browser.reloadViaWindowLocation(step.url)});nextStepSequenceView.render()}})};NextStepSequenceComponent.prototype._generateSteps=function(){var steps=[];if(this.canBrowseProjects){steps.push(NextStepSequenceComponent.STEPS.BROWSE_PROJECTS)}if(this.canCreateIssues){steps.push(NextStepSequenceComponent.STEPS.CREATE_ISSUE)}if(this.canSearchIssues){steps.push(NextStepSequenceComponent.STEPS.SEARCH_ISSUES)}return steps};NextStepSequenceComponent.STEPS={BROWSE_PROJECTS:{key:"browseprojects",url:wrmContextPath()+"/secure/BrowseProjects.jspa?selectedCategory=all",label:formatter.I18n.getText("onboarding.next.step.projects.label"),icon:wrmContextPath()+"/download/resources/com.atlassian.jira.jira-onboarding-assets-plugin:next-step-component/explore.svg"},CREATE_ISSUE:{key:"createissue",url:wrmContextPath()+"/secure/CreateIssue!default.jspa",label:formatter.I18n.getText("onboarding.next.step.create.issue.label"),icon:wrmContextPath()+"/download/resources/com.atlassian.jira.jira-onboarding-assets-plugin:next-step-component/create.svg"},SEARCH_ISSUES:{key:"searchissues",url:wrmContextPath()+"/issues",label:formatter.I18n.getText("onboarding.next.step.search.issues.label"),icon:wrmContextPath()+"/download/resources/com.atlassian.jira.jira-onboarding-assets-plugin:next-step-component/search.svg"}};NextStepSequenceComponent.REJECTION_TYPES={NO_PERMISSIONS:"nopermissions"};return NextStepSequenceComponent});