define("jira/onboarding/create-project-sequence-view",["jira/util/formatter","wrm/context-path","jquery","backbone","underscore","jira/field/create-project-field","jira/onboarding/services/create-project-service"],function(formatter,wrmContextPath,$,Backbone,_,CreateProjectField,CreateProjectService){var MAX_NAME_LENGTH=80;var MAX_KEY_LENGTH=10;var BAD_REQUEST=400;var UNAUTHORISED=401;var LOGIN_URL=wrmContextPath()+"/login.jsp?os_destination="+encodeURIComponent(window.location.href);var Templates=JIRA.Onboarding.Sequence.CreateProject;return Backbone.View.extend({events:{submit:"_createProject","click #skip":"_skip"},initialize:function(options){this.maxKeyLength=options.maxKeyLength||MAX_KEY_LENGTH;this.maxNameLength=options.maxNameLength||MAX_NAME_LENGTH;this.leadName=options.leadName;this.projectTemplateKey=options.projectTemplateKey},render:function(){this.$el.html(Templates.render({maxNameLength:this.maxNameLength,maxKeyLength:this.maxKeyLength,projectTemplateKey:this.projectTemplateKey}));this.createProjectField=new CreateProjectField({element:this.$el});this.$("input").first().focus();this.createProjectField.bind("updated.Name",_.bind(this._formChange,this));this.createProjectField.bind("updated.Key",_.bind(this._formChange,this))},_createProject:function(event){event.preventDefault();var view=this;var fields=this._getProjectFields();if(fields){this._showLoadingSpinner();this._disableCreateProject();CreateProjectService.createProject(fields).done(function(response){view.trigger("done",response)}).fail(function(response){if(typeof response!=="undefined"){view._generateErrorMessage(fields,response)}view._enableCreateProject();view._hideLoadingSpinner()})}},_formChange:function(){if(!this.loading){if(this._validate()){this._enableCreateProject()}else{this._disableCreateProject()}}},_skip:function(event){event.preventDefault();this.trigger("skip")},_getProjectFields:function(){if(this._validate()){return{name:this._getProjectName(),key:this._getProjectKey(),lead:this._getLeadName(),projectTemplateWebItemKey:this.projectTemplateKey}}return null},_showLoadingSpinner:function(){this.loading=true;this.$el.find(".submit-spinner").addClass("show")},_hideLoadingSpinner:function(){this.loading=false;this.$el.find(".submit-spinner").removeClass("show")},_enableCreateProject:function(){this.$el.find("input[type=submit]").removeAttr("disabled").attr("aria-disabled","false")},_disableCreateProject:function(){this.$el.find("input[type=submit]").attr("disabled",true).attr("aria-disabled","true")},_getProjectName:function(){return this.createProjectField.$nameElement.val()},_getProjectKey:function(){return this.createProjectField.$keyElement.val()},_getLeadName:function(){return this.leadName},_validate:function(){var valid=true;var projectName=this._getProjectName();var projectKey=this._getProjectKey();if(!projectName){valid=false}else{if(!projectKey){valid=false}else{if(this.$el.find(".error").is(":visible")){valid=false}}}return valid},_generateErrorMessage:function(fields,response){var content="";var title="";if(response.status===BAD_REQUEST){var responseJSON=$.parseJSON(response.responseText);title=formatter.I18n.getText("admin.errors.project.could.not.create",fields.name);content=Templates.errors({errors:responseJSON.errors})}else{if(response.status===UNAUTHORISED){title=formatter.I18n.getText("common.forms.ajax.unauthorised.alert");content=Templates.loginLink({loginUrl:LOGIN_URL})}else{title=formatter.I18n.getText("500.title")}}this.$el.find(".form-errors").html(AJS.messages.error({title:title,body:content}))}})});