define("jira/onboarding/choose-language-sequence",["require"],function(require){var _=require("underscore");var Browser=require("jira/util/browser");var LocalStorage=require("jira/data/local-storage");var ChooseLanguageSequenceView=require("jira/onboarding/choose-language-sequence-view");var ChooseLanguageSequenceModel=require("jira/onboarding/choose-language-sequence-model");var wrmContextPath=require("wrm/context-path");var Promise=require("bluebird/Promise");var SYSTEM_DEFAULT_LOCALE="-1";var SELECTED_LANG_STORAGE_KEY="jira.onboarding.choose.language.data";var SUCCESS_STORAGE_KEY="jira.onboarding.choose.language.success";var ChooseLanguageSequence=function(options){options=_.extend({languages:{},translations:{}},options);this.currentLocale=options.currentLocale;this.defaultLocale=options.defaultLocale;this.userPrefKey=options.userPrefKey;this.languages={};_.forEach(options.languages,function(language,key){this.languages[key]={name:language,value:key,i18n:options.translations[key]}},this)};ChooseLanguageSequence.prototype.init=function(container,analytics){var instance=this;var currentLocale=this.currentLocale;return new Promise(function(resolve,reject){if(!instance.languages||_.keys(instance.languages).length<2){analytics.pushEvent(ChooseLanguageSequence.EVENTS.NO_LANGUAGES);reject(ChooseLanguageSequence.EVENTS.NO_LANGUAGES);return }function finishSequence(lang,oldLang){var data={language:lang,oldLanguage:oldLang,choseDefault:false};if(lang===SYSTEM_DEFAULT_LOCALE&&instance.defaultLocale){data.language=instance.defaultLocale;data.choseDefault=true}analytics.pushEvent(ChooseLanguageSequence.EVENTS.DONE,data);resolve(ChooseLanguageSequence.EVENTS.DONE)}var userChoice=SYSTEM_DEFAULT_LOCALE;if(LocalStorage.getItem(SELECTED_LANG_STORAGE_KEY)){userChoice=LocalStorage.getItem(SELECTED_LANG_STORAGE_KEY);LocalStorage.removeItem(SELECTED_LANG_STORAGE_KEY)}if(LocalStorage.getItem(SUCCESS_STORAGE_KEY)){var lang=LocalStorage.getItem(SUCCESS_STORAGE_KEY);LocalStorage.removeItem(SUCCESS_STORAGE_KEY);finishSequence(lang,userChoice);return }var model=new ChooseLanguageSequenceModel({selected:userChoice},{languages:instance.languages,userPrefKey:instance.userPrefKey});var view=new ChooseLanguageSequenceView({el:container,model:model});view.once("done",function(response){var locale=model.get("selected");if(currentLocale&&currentLocale===locale){finishSequence(locale,currentLocale);return }var options={success:function(model,response,opts){LocalStorage.setItem(SELECTED_LANG_STORAGE_KEY,currentLocale);LocalStorage.setItem(SUCCESS_STORAGE_KEY,opts.data);Browser.reloadViaWindowLocation(window.location.href)},error:function(model,response,opts){var error={message:"Unknown error",statusCode:response.status};try{error.message=JSON.parse(response.responseText).message}catch(e){error.message+="; JSON parse of error response failed"}if(error.statusCode===401){analytics.pushEvent(ChooseLanguageSequence.EVENTS.NOT_AUTHORIZED);LocalStorage.setItem(SELECTED_LANG_STORAGE_KEY,opts.data);Browser.reloadViaWindowLocation(wrmContextPath()+"/login.jsp?os_destination="+encodeURIComponent(window.location.href));return }analytics.pushEvent(ChooseLanguageSequence.EVENTS.ERROR_ON_SAVE,{error:error,language:opts.data});reject(ChooseLanguageSequence.EVENTS.ERROR_ON_SAVE)}};if(locale===SYSTEM_DEFAULT_LOCALE){model.destroy(options)}else{model.save(null,options)}});view.once("skip",function(){analytics.pushEvent(ChooseLanguageSequence.EVENTS.SKIPPED);reject(ChooseLanguageSequence.EVENTS.SKIPPED)});view.render()})};ChooseLanguageSequence.EVENTS={NO_LANGUAGES:"noLanguages",NOT_AUTHORIZED:"notAuthorized",ERROR_ON_SAVE:"errorOnSave",DONE:"done",SKIPPED:"skipped"};return ChooseLanguageSequence});