define("jira/onboarding/sequence-controller",["wrm/context-path","jquery","underscore","jira/data/local-storage","jira/util/browser","jira/onboarding/analytics","bluebird/Promise"],function(wrmContextPath,$,_,LocalStorage,Browser,OnboardingAnalytics,Promise){var ONBOARDING_RESUME_KEY="onboarding.sequence.started";var SequenceController=function(options){options=options||{};if(!options.container){throw new Error("Should have passed a container to put the sequence content")}else{var isjQuery=options.container instanceof $;var isDomNode=options.container instanceof HTMLElement;if(isjQuery){options.container=options.container.get(0)}if(!isjQuery&&!isDomNode){throw new Error("Container must be a DOM node")}}if(!options.flow){throw new Error("Should have flow information for controller")}if(typeof options.flow!=="function"){throw new Error("First use flow should be a function")}this.container=options.container;this.flow=options.flow(_.bind(this.complete,this));this.currentFlowKey=options.flowKey;if(!this.flow.sequences){throw new Error("Should have sequences in the controller")}if(!this.flow.start){throw new Error("Should have a start point for the flow")}if(!this.flow.sequences[this.flow.start]){throw new Error("Start point should actually be a sequence")}};SequenceController.prototype.start=function(sequenceKey){sequenceKey=LocalStorage.getItem(ONBOARDING_RESUME_KEY)||sequenceKey;if(!sequenceKey||!this.hasSequence(sequenceKey)){sequenceKey=this.flow.start}this._executeSequence(sequenceKey)};SequenceController.prototype._executeSequence=function(sequenceKey){var instance=this;var sequence=this.flow.sequences[sequenceKey];var element=document.createElement("div");$(this.container).html(element);var analytics=new OnboardingAnalytics(this.flow.key,sequenceKey);analytics.pushEvent(OnboardingAnalytics.EVENTS.STARTED_SEQUENCE);sequence.instance.init(element,analytics).then(function(){instance._completeSequence(sequence,"resolve",arguments)},function(){instance._completeSequence(sequence,"reject",arguments)})};SequenceController.prototype._completeSequence=function(sequence,result,resultArguments){var nextSequenceKey;if(typeof sequence[result]==="string"){nextSequenceKey=sequence[result]}else{if(typeof sequence[result]==="function"){nextSequenceKey=sequence[result].apply(this,resultArguments)}}LocalStorage.removeItem(ONBOARDING_RESUME_KEY);if(!nextSequenceKey||!this.hasSequence(nextSequenceKey)){return false}this._updateCurrentSequence(nextSequenceKey);this._executeSequence(nextSequenceKey)};SequenceController.prototype.hasSequence=function(sequenceKey){return(this.flow.sequences[sequenceKey]!==undefined)};SequenceController.prototype._updateCurrentSequence=function(sequenceKey){if(this.currentFlowKey){$.ajax({url:createCurrentSequenceUrl(this.currentFlowKey,sequenceKey),type:"POST",statusCode:{401:function(){LocalStorage.setItem(ONBOARDING_RESUME_KEY,sequenceKey);unauthorisedRequestHandler()}}})}};SequenceController.prototype.complete=function(){return new Promise(_.bind(function(resolve){if(this.currentFlowKey){$.ajax({url:createCompleteFlowUrl(this.currentFlowKey),type:"POST",statusCode:{401:unauthorisedRequestHandler}}).always(resolve)}else{resolve()}},this))};function createCompleteFlowUrl(flow){return wrmContextPath()+"/rest/onboarding/1.0/flow/"+flow+"/complete"}function createCurrentSequenceUrl(flow,sequence){return wrmContextPath()+"/rest/onboarding/1.0/flow/"+flow+"/sequence/current/"+sequence}function unauthorisedRequestHandler(){Browser.reloadViaWindowLocation(wrmContextPath()+"/login.jsp?os_destination="+encodeURIComponent(window.location.href))}return SequenceController});