/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.rest;

import com.atlassian.jira.onboarding.OnboardingService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/flow")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class FlowResource {
    private final JiraAuthenticationContext authenticationContext;
    private final OnboardingService onboardingService;

    public FlowResource(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport OnboardingService onboardingService) {
        this.authenticationContext = jiraAuthenticationContext;
        this.onboardingService = onboardingService;
    }

    @POST
    @Path(value="/{flow}/complete")
    public Response completeFlow(@PathParam(value="flow") String flowKey) {
        if (this.isCompletingFlow(flowKey)) {
            this.onboardingService.completeFirstUseFlow(this.getUser());
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Has not started a flow").build();
    }

    @POST
    @Path(value="/{flow}/sequence/current/{sequenceKey}")
    public Response setCurrentSequence(@PathParam(value="flow") String flowKey, @PathParam(value="sequenceKey") String sequenceKey) {
        if (this.isCompletingFlow(flowKey)) {
            this.onboardingService.setCurrentFirstUseFlowSequence(this.getUser(), sequenceKey);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Has not started a flow").build();
    }

    private boolean isCompletingFlow(@Nullable String flowKey) {
        String currentFlow = this.onboardingService.getStartedFirstUseFlowKey(this.getUser());
        return flowKey != null && currentFlow != null && currentFlow.equals(flowKey);
    }

    private ApplicationUser getUser() {
        return this.authenticationContext.getUser();
    }
}

