/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.data;

import com.atlassian.jira.onboarding.OnboardingService;
import com.atlassian.jira.onboarding.data.AbstractOnboardingDataProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class SequenceControllerDataProvider
extends AbstractOnboardingDataProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final OnboardingService onboardingService;

    public SequenceControllerDataProvider(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport OnboardingService onboardingService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.onboardingService = onboardingService;
    }

    @Override
    JSONObject getJsonData() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        HashMap values = Maps.newHashMap();
        values.put("currentSequenceKey", this.getCurrentSequenceKey(user));
        values.put("currentFlow", this.getCurrentFlowKey(user));
        return new JSONObject((Map)values);
    }

    @ActionViewData
    public String getCurrentSequenceKey(ApplicationUser user) {
        return this.onboardingService.getCurrentFirstUseFlowSequence(user);
    }

    @ActionViewData
    public String getCurrentFlowKey(ApplicationUser user) {
        return this.onboardingService.getStartedFirstUseFlowKey(user);
    }
}

