/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.data;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.onboarding.data.AbstractOnboardingDataProvider;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class CyoaDataProvider
extends AbstractOnboardingDataProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final ProjectService projectService;

    public CyoaDataProvider(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport ProjectService projectService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.projectService = projectService;
    }

    @Override
    JSONObject getJsonData() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ServiceOutcome accessibleProjects = this.projectService.getAllProjects(user);
        ImmutableMap values = ImmutableMap.of((Object)"username", (Object)this.getUsername(user), (Object)"userFullname", (Object)this.getUserFullName(user), (Object)"hasAdministerPermission", (Object)this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user), (Object)"projectCount", (Object)(accessibleProjects.isValid() ? ((List)accessibleProjects.getReturnedValue()).size() : 0));
        return new JSONObject((Map)values);
    }

    private String getUsername(ApplicationUser user) {
        return user.getUsername();
    }

    private String getUserFullName(ApplicationUser user) {
        return user.getDisplayName();
    }
}

