/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.data;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.onboarding.data.AbstractOnboardingDataProvider;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.template.ProjectTemplateManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class CreateProjectSequenceData
extends AbstractOnboardingDataProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final ProjectService projectService;
    private final ProjectTemplateManager projectTemplateManager;

    public CreateProjectSequenceData(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport ProjectService projectService, @ComponentImport ProjectTemplateManager projectTemplateManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.globalPermissionManager = globalPermissionManager;
        this.projectService = projectService;
        this.projectTemplateManager = projectTemplateManager;
    }

    @Override
    JSONObject getJsonData() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        HashMap values = Maps.newHashMap();
        values.put("username", this.getUsername(user));
        values.put("canCompleteCreateProjectSequence", this.getCanCompleteCreateProjectSequence(user));
        values.put("maxKeyLength", this.projectService.getMaximumKeyLength());
        values.put("maxNameLength", this.projectService.getMaximumNameLength());
        values.put("projectTemplateKey", this.getProjectTemplateKey());
        return new JSONObject((Map)values);
    }

    private String getUsername(ApplicationUser user) {
        return user.getUsername();
    }

    private String getProjectTemplateKey() {
        try {
            return this.projectTemplateManager.getDefaultTemplate().getKey().getKey();
        }
        catch (IllegalStateException e) {
            return "";
        }
    }

    public Boolean getCanCompleteCreateProjectSequence(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }
}

