/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.data;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.onboarding.data.AbstractOnboardingDataProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class AvatarPickerDataProvider
extends AbstractOnboardingDataProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final AvatarService avatarService;
    private final AvatarManager avatarManager;

    public AvatarPickerDataProvider(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport AvatarService avatarService, @ComponentImport AvatarManager avatarManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.avatarService = avatarService;
        this.avatarManager = avatarManager;
    }

    @Override
    JSONObject getJsonData() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        HashMap values = Maps.newHashMap();
        values.put("username", this.getUsername(user));
        values.put("userFullname", this.getUserFullName(user));
        values.put("userAvatarId", this.getUserAvatarId(user));
        values.put("userAvatarUrl", this.getUserAvatarUrl(user));
        values.put("defaultUserAvatarId", this.getDefaultUserAvatarId());
        return new JSONObject((Map)values);
    }

    private Long getUserAvatarId(ApplicationUser user) {
        return this.avatarService.getAvatar(user, user).getId();
    }

    private String getUserAvatarUrl(ApplicationUser user) {
        return this.avatarService.getAvatarAbsoluteURL(user, user, Avatar.Size.defaultSize()).toString();
    }

    private String getDefaultUserAvatarId() {
        return String.valueOf(this.avatarManager.getDefaultAvatarId(Avatar.Type.USER));
    }

    private String getUsername(ApplicationUser user) {
        return user.getUsername();
    }

    private String getUserFullName(ApplicationUser user) {
        return user.getDisplayName();
    }
}

