/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.oauth.serviceprovider;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.oauth.serviceprovider.StoreException;
import com.atlassian.oauth.util.RSAKeys;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizServiceProviderConsumerStore
implements ServiceProviderConsumerStore {
    public static final String TABLE = "OAuthServiceProviderConsumer";
    public static final boolean IS_2LO_ALLOWED_DEFAULT = false;
    private static final boolean IS_3LO_ALLOWED_DEFAULT = true;
    private final OfBizDelegator delegator;

    public OfBizServiceProviderConsumerStore(OfBizDelegator delegator) {
        Assertions.notNull((String)"delegator", (Object)delegator);
        this.delegator = delegator;
    }

    public void put(Consumer consumer) throws StoreException {
        block5: {
            Assertions.notNull((String)"consumer", (Object)consumer);
            Assertions.notNull((String)"consumer.key", (Object)consumer.getKey());
            Assertions.notNull((String)"consumer.name", (Object)consumer.getName());
            Assertions.notNull((String)"consumer.publicKey", (Object)consumer.getPublicKey());
            Timestamp now = new Timestamp(System.currentTimeMillis());
            Map fieldValues = MapBuilder.newBuilder().add((Object)"consumerKey", (Object)consumer.getKey()).add((Object)"created", (Object)now).add((Object)"name", (Object)consumer.getName()).add((Object)"publicKey", (Object)RSAKeys.toPemEncoding((Key)consumer.getPublicKey())).add((Object)"description", (Object)(consumer.getDescription() == null ? "" : consumer.getDescription())).add((Object)"callback", consumer.getCallback() != null ? consumer.getCallback().toASCIIString() : null).add((Object)"twoLOAllowed", (Object)consumer.getTwoLOAllowed()).add((Object)"executingTwoLOUser", (Object)consumer.getExecutingTwoLOUser()).add((Object)"twoLOImpersonationAllowed", (Object)consumer.getTwoLOImpersonationAllowed()).add((Object)"threeLOAllowed", (Object)consumer.getThreeLOAllowed()).toMap();
            try {
                List consumerGVs = this.delegator.findByAnd(TABLE, MapBuilder.newBuilder().add((Object)"consumerKey", (Object)consumer.getKey()).toMap());
                if (!consumerGVs.isEmpty()) {
                    GenericValue gv = (GenericValue)consumerGVs.get(0);
                    gv.setNonPKFields(fieldValues);
                    try {
                        gv.store();
                        break block5;
                    }
                    catch (GenericEntityException e) {
                        throw new DataAccessException((Throwable)e);
                    }
                }
                this.delegator.createValue(TABLE, fieldValues);
            }
            catch (DataAccessException e) {
                throw new StoreException((Throwable)e);
            }
        }
    }

    public Consumer get(String key) throws StoreException {
        Assertions.notNull((String)"key", (Object)key);
        try {
            List consumerTokenGVs = this.delegator.findByAnd(TABLE, MapBuilder.newBuilder().add((Object)"consumerKey", (Object)key).toMap());
            if (!consumerTokenGVs.isEmpty()) {
                return this.createConsumerFromGV((GenericValue)consumerTokenGVs.get(0));
            }
            return null;
        }
        catch (DataAccessException e) {
            throw new StoreException((Throwable)e);
        }
    }

    public void remove(String key) throws StoreException {
        Assertions.notNull((String)"key", (Object)key);
        try {
            this.delegator.removeByAnd(TABLE, MapBuilder.newBuilder().add((Object)"consumerKey", (Object)key).toMap());
        }
        catch (DataAccessException e) {
            throw new StoreException((Throwable)e);
        }
    }

    public Iterable<Consumer> getAll() throws StoreException {
        try {
            List consumerGVs = this.delegator.findAll(TABLE);
            return CollectionUtil.transform((Iterable)consumerGVs, (Function)new Function<GenericValue, Consumer>(){

                public Consumer get(GenericValue input) {
                    return OfBizServiceProviderConsumerStore.this.createConsumerFromGV(input);
                }
            });
        }
        catch (DataAccessException e) {
            throw new StoreException((Throwable)e);
        }
    }

    private Consumer createConsumerFromGV(GenericValue gv) {
        try {
            try {
                PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)gv.getString("publicKey"));
                String uriString = gv.getString("callback");
                String description = gv.getString("description") == null ? "" : gv.getString("description");
                URI callBack = null;
                if (StringUtils.isNotEmpty((String)uriString)) {
                    callBack = new URI(uriString);
                }
                Boolean is2LoAllowed = gv.getBoolean("twoLOAllowed");
                Boolean is3LoAllowed = gv.getBoolean("threeLOAllowed");
                return Consumer.key((String)gv.getString("consumerKey")).name(gv.getString("name")).publicKey(publicKey).description(description).callback(callBack).twoLOAllowed(is2LoAllowed != null ? is2LoAllowed : false).executingTwoLOUser(gv.getString("executingTwoLOUser")).twoLOImpersonationAllowed(is2LoAllowed != null ? gv.getBoolean("twoLOImpersonationAllowed") : false).threeLOAllowed(is3LoAllowed != null ? gv.getBoolean("threeLOAllowed") : true).build();
            }
            catch (NoSuchAlgorithmException e) {
                throw new StoreException((Throwable)e);
            }
            catch (InvalidKeySpecException e) {
                throw new StoreException((Throwable)e);
            }
        }
        catch (URISyntaxException e) {
            throw new StoreException("callback URI is not valid", (Throwable)e);
        }
    }

    public static final class Columns {
        public static final String ID = "id";
        public static final String CREATED = "created";
        public static final String KEY = "consumerKey";
        public static final String NAME = "name";
        public static final String PUBLIC_KEY = "publicKey";
        public static final String DESCRIPTION = "description";
        public static final String CALLBACK = "callback";
        public static final String IS_2LO_ALLOWED = "twoLOAllowed";
        public static final String EXECUTING_2LO_USER = "executingTwoLOUser";
        public static final String IS_2LO_IMPERSONATION_ALLOWED = "twoLOImpersonationAllowed";
        public static final String IS_3LO_ALLOWED = "threeLOAllowed";
    }
}

